/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricTagger;
import com.hazelcast.internal.metrics.MetricTaggerSupplier;
import com.hazelcast.internal.metrics.MetricsExtractor;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.monitor.LocalIndexStats;
import com.hazelcast.monitor.LocalInstanceStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceManager;
import java.util.Map;

public final class StatisticsAwareMetricsSet {
    private StatisticsAwareMetricsSet() {
    }

    public static void register(ServiceManager serviceManager, MetricsRegistry metricsRegistry) {
        metricsRegistry.registerDynamicMetricsProvider(new StatisticsAwareDynamicProvider(serviceManager));
    }

    private static final class StatisticsAwareDynamicProvider
    implements DynamicMetricsProvider {
        private final ServiceManager serviceManager;

        private StatisticsAwareDynamicProvider(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        @Override
        public void provideDynamicMetrics(MetricTaggerSupplier taggerSupplier, MetricsExtractor extractor) {
            for (StatisticsAwareService statisticsAwareService : this.serviceManager.getServices(StatisticsAwareService.class)) {
                Map stats = statisticsAwareService.getStats();
                if (stats == null) continue;
                for (Map.Entry entry : stats.entrySet()) {
                    MetricTagger tagger;
                    LocalInstanceStats localInstanceStats = (LocalInstanceStats)entry.getValue();
                    String name = entry.getKey();
                    NearCacheStats nearCacheStats = this.getNearCacheStats(localInstanceStats);
                    String baseName = localInstanceStats.getClass().getSimpleName().replace("Stats", "").replace("Local", "").replace("Impl", "");
                    baseName = StringUtil.lowerCaseFirstChar(baseName);
                    if (nearCacheStats != null) {
                        tagger = taggerSupplier.getMetricTagger(baseName + ".nearcache").withIdTag("name", name);
                        extractor.extractMetrics(tagger, nearCacheStats);
                    }
                    if (localInstanceStats instanceof LocalMapStatsImpl) {
                        Map<String, LocalIndexStats> indexStats = ((LocalMapStatsImpl)localInstanceStats).getIndexStats();
                        for (Map.Entry<String, LocalIndexStats> indexEntry : indexStats.entrySet()) {
                            MetricTagger tagger2 = taggerSupplier.getMetricTagger(baseName + ".index").withIdTag("name", name).withTag("index", indexEntry.getKey());
                            extractor.extractMetrics(tagger2, indexEntry.getValue());
                        }
                    }
                    tagger = taggerSupplier.getMetricTagger(baseName).withIdTag("name", name);
                    extractor.extractMetrics(tagger, localInstanceStats);
                }
            }
        }

        private NearCacheStats getNearCacheStats(LocalInstanceStats localInstanceStats) {
            if (localInstanceStats instanceof LocalMapStatsImpl) {
                LocalMapStats localMapStats = (LocalMapStats)localInstanceStats;
                return localMapStats.getNearCacheStats();
            }
            if (localInstanceStats instanceof CacheStatistics) {
                CacheStatistics localMapStats = (CacheStatistics)((Object)localInstanceStats);
                return localMapStats.getNearCacheStatistics();
            }
            return null;
        }
    }
}

