/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.tcp;

import com.hazelcast.config.Config;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricTagger;
import com.hazelcast.internal.metrics.MetricTaggerSupplier;
import com.hazelcast.internal.metrics.MetricsExtractor;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.ChannelInitializerProvider;
import com.hazelcast.internal.networking.Networking;
import com.hazelcast.internal.networking.ServerSocketRegistry;
import com.hazelcast.internal.nio.AggregateEndpointManager;
import com.hazelcast.internal.nio.DefaultAggregateEndpointManager;
import com.hazelcast.internal.nio.EndpointManager;
import com.hazelcast.internal.nio.IOService;
import com.hazelcast.internal.nio.NetworkingService;
import com.hazelcast.internal.nio.UnifiedAggregateEndpointManager;
import com.hazelcast.internal.nio.tcp.ClientViewUnifiedEndpointManager;
import com.hazelcast.internal.nio.tcp.MemberViewUnifiedEndpointManager;
import com.hazelcast.internal.nio.tcp.TcpIpAcceptor;
import com.hazelcast.internal.nio.tcp.TcpIpConnection;
import com.hazelcast.internal.nio.tcp.TcpIpEndpointManager;
import com.hazelcast.internal.nio.tcp.TcpIpUnifiedEndpointManager;
import com.hazelcast.internal.nio.tcp.TextViewUnifiedEndpointManager;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.concurrent.ThreadFactoryImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class TcpIpNetworkingService
implements NetworkingService<TcpIpConnection> {
    private static final int SCHEDULER_POOL_SIZE = 4;
    private final IOService ioService;
    private final ILogger logger;
    private final Networking networking;
    private final MetricsRegistry metricsRegistry;
    private ScheduledFuture refreshStatsFuture;
    private final RefreshNetworkStatsTask refreshStatsTask;
    private final int refreshStatsIntervalSeconds;
    private final ServerSocketRegistry registry;
    private final ConcurrentMap<EndpointQualifier, EndpointManager<TcpIpConnection>> endpointManagers = new ConcurrentHashMap<EndpointQualifier, EndpointManager<TcpIpConnection>>();
    private final TcpIpUnifiedEndpointManager unifiedEndpointManager;
    private final AggregateEndpointManager aggregateEndpointManager;
    private final ScheduledExecutorService scheduler;
    private final AtomicReference<TcpIpAcceptor> acceptorRef = new AtomicReference();
    private volatile boolean live;

    TcpIpNetworkingService(Config config, IOService ioService, ServerSocketRegistry registry, LoggingService loggingService, MetricsRegistry metricsRegistry, Networking networking, ChannelInitializerProvider channelInitializerProvider) {
        this(config, ioService, registry, loggingService, metricsRegistry, networking, channelInitializerProvider, null);
    }

    public TcpIpNetworkingService(Config config, IOService ioService, ServerSocketRegistry registry, LoggingService loggingService, MetricsRegistry metricsRegistry, Networking networking, ChannelInitializerProvider channelInitializerProvider, HazelcastProperties properties) {
        this.ioService = ioService;
        this.networking = networking;
        this.metricsRegistry = metricsRegistry;
        this.refreshStatsTask = new RefreshNetworkStatsTask(this.endpointManagers);
        this.refreshStatsIntervalSeconds = properties != null ? properties.getInteger(GroupProperty.NETWORK_STATS_REFRESH_INTERVAL_SECONDS) : 1;
        this.registry = registry;
        this.logger = loggingService.getLogger(TcpIpNetworkingService.class);
        this.scheduler = new ScheduledThreadPoolExecutor(4, new ThreadFactoryImpl(ThreadUtil.createThreadPoolName(ioService.getHazelcastName(), "TcpIpNetworkingService")));
        this.unifiedEndpointManager = registry.holdsUnifiedSocket() ? new TcpIpUnifiedEndpointManager(this, null, channelInitializerProvider, ioService, loggingService, properties) : null;
        this.initEndpointManager(config, ioService, loggingService, channelInitializerProvider, properties);
        if (this.unifiedEndpointManager != null) {
            this.aggregateEndpointManager = new UnifiedAggregateEndpointManager(this.unifiedEndpointManager, this.endpointManagers);
        } else {
            this.aggregateEndpointManager = new DefaultAggregateEndpointManager(this.endpointManagers);
            this.refreshStatsTask.registerMetrics(metricsRegistry);
        }
        metricsRegistry.registerDynamicMetricsProvider(new MetricsProvider(this.acceptorRef, this.endpointManagers));
    }

    private void initEndpointManager(Config config, IOService ioService, LoggingService loggingService, ChannelInitializerProvider channelInitializerProvider, HazelcastProperties properties) {
        if (this.unifiedEndpointManager != null) {
            this.endpointManagers.put(EndpointQualifier.MEMBER, new MemberViewUnifiedEndpointManager(this.unifiedEndpointManager));
            this.endpointManagers.put(EndpointQualifier.CLIENT, new ClientViewUnifiedEndpointManager(this.unifiedEndpointManager));
            this.endpointManagers.put(EndpointQualifier.REST, new TextViewUnifiedEndpointManager(this.unifiedEndpointManager, true));
            this.endpointManagers.put(EndpointQualifier.MEMCACHE, new TextViewUnifiedEndpointManager(this.unifiedEndpointManager, false));
        } else {
            for (EndpointConfig endpointConfig : config.getAdvancedNetworkConfig().getEndpointConfigs().values()) {
                EndpointQualifier qualifier = endpointConfig.getQualifier();
                EndpointManager<TcpIpConnection> em = this.newEndpointManager(ioService, endpointConfig, channelInitializerProvider, loggingService, properties, Collections.singleton(endpointConfig.getProtocolType()));
                this.endpointManagers.put(qualifier, em);
            }
        }
    }

    private EndpointManager<TcpIpConnection> newEndpointManager(IOService ioService, EndpointConfig endpointConfig, ChannelInitializerProvider channelInitializerProvider, LoggingService loggingService, HazelcastProperties properties, Set<ProtocolType> supportedProtocolTypes) {
        return new TcpIpEndpointManager(this, endpointConfig, channelInitializerProvider, ioService, loggingService, properties, supportedProtocolTypes);
    }

    @Override
    public IOService getIoService() {
        return this.ioService;
    }

    @Override
    public Networking getNetworking() {
        return this.networking;
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public synchronized void start() {
        if (this.live) {
            return;
        }
        if (!this.registry.isOpen()) {
            throw new IllegalStateException("Networking Service is already shutdown. Cannot start!");
        }
        this.live = true;
        this.logger.finest("Starting Networking Service and IO selectors.");
        this.networking.restart();
        this.startAcceptor();
        if (this.unifiedEndpointManager == null) {
            this.refreshStatsFuture = this.metricsRegistry.scheduleAtFixedRate(this.refreshStatsTask, this.refreshStatsIntervalSeconds, TimeUnit.SECONDS, ProbeLevel.INFO);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.live) {
            return;
        }
        this.live = false;
        this.logger.finest("Stopping Networking Service");
        if (this.refreshStatsFuture != null) {
            this.refreshStatsFuture.cancel(false);
            this.refreshStatsFuture = null;
        }
        this.shutdownAcceptor();
        if (this.unifiedEndpointManager != null) {
            this.unifiedEndpointManager.reset(false);
        } else {
            for (EndpointManager endpointManager : this.endpointManagers.values()) {
                ((TcpIpEndpointManager)endpointManager).reset(false);
            }
        }
        this.networking.shutdown();
    }

    @Override
    public synchronized void shutdown() {
        this.shutdownAcceptor();
        this.closeServerSockets();
        this.stop();
        this.scheduler.shutdownNow();
        if (this.unifiedEndpointManager != null) {
            this.unifiedEndpointManager.reset(true);
        } else {
            for (EndpointManager endpointManager : this.endpointManagers.values()) {
                ((TcpIpEndpointManager)endpointManager).reset(true);
            }
        }
    }

    @Override
    public AggregateEndpointManager getAggregateEndpointManager() {
        return this.aggregateEndpointManager;
    }

    @Override
    public EndpointManager<TcpIpConnection> getEndpointManager(EndpointQualifier qualifier) {
        EndpointManager mgr = (EndpointManager)this.endpointManagers.get(qualifier);
        if (mgr == null) {
            this.logger.finest("An endpoint manager for qualifier " + qualifier + " was never registered.");
        }
        return mgr;
    }

    EndpointManager<TcpIpConnection> getUnifiedOrDedicatedEndpointManager(EndpointQualifier qualifier) {
        return this.unifiedEndpointManager != null ? this.unifiedEndpointManager : (EndpointManager)this.endpointManagers.get(qualifier);
    }

    @Override
    public void scheduleDeferred(Runnable task, long delay, TimeUnit unit) {
        this.scheduler.schedule(task, delay, unit);
    }

    private void startAcceptor() {
        if (this.acceptorRef.get() != null) {
            this.logger.warning("TcpIpAcceptor is already running! Shutting down old acceptorRef...");
            this.shutdownAcceptor();
        }
        this.acceptorRef.set(new TcpIpAcceptor(this.registry, this, this.ioService).start());
    }

    private void shutdownAcceptor() {
        TcpIpAcceptor acceptor = this.acceptorRef.get();
        if (acceptor != null) {
            acceptor.shutdown();
            this.acceptorRef.set(null);
        }
    }

    private void closeServerSockets() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Closing server socket channel: " + this.registry);
        }
        this.registry.destroy();
    }

    private static final class MetricsProvider
    implements DynamicMetricsProvider {
        private final AtomicReference<TcpIpAcceptor> acceptorRef;
        private final ConcurrentMap<EndpointQualifier, EndpointManager<TcpIpConnection>> endpointManagers;

        private MetricsProvider(AtomicReference<TcpIpAcceptor> acceptorRef, ConcurrentMap<EndpointQualifier, EndpointManager<TcpIpConnection>> endpointManagers) {
            this.acceptorRef = acceptorRef;
            this.endpointManagers = endpointManagers;
        }

        @Override
        public void provideDynamicMetrics(MetricTaggerSupplier taggerSupplier, MetricsExtractor extractor) {
            MetricTagger tagger = taggerSupplier.getMetricTagger("tcp");
            extractor.extractMetrics(tagger, this);
            TcpIpAcceptor acceptor = this.acceptorRef.get();
            if (acceptor != null) {
                acceptor.provideDynamicMetrics(taggerSupplier, extractor);
            }
            for (EndpointManager manager : this.endpointManagers.values()) {
                if (!(manager instanceof DynamicMetricsProvider)) continue;
                ((DynamicMetricsProvider)((Object)manager)).provideDynamicMetrics(taggerSupplier, extractor);
            }
        }
    }

    private static final class RefreshNetworkStatsTask
    implements Runnable {
        private final ConcurrentMap<EndpointQualifier, EndpointManager<TcpIpConnection>> endpointManagers;
        private final EnumMap<ProtocolType, AtomicLong> bytesReceivedPerProtocol;
        private final EnumMap<ProtocolType, AtomicLong> bytesSentPerProtocol;

        RefreshNetworkStatsTask(ConcurrentMap<EndpointQualifier, EndpointManager<TcpIpConnection>> endpointManagers) {
            this.endpointManagers = endpointManagers;
            this.bytesReceivedPerProtocol = new EnumMap(ProtocolType.class);
            this.bytesSentPerProtocol = new EnumMap(ProtocolType.class);
            for (ProtocolType type : ProtocolType.valuesAsSet()) {
                this.bytesReceivedPerProtocol.put(type, new AtomicLong());
                this.bytesSentPerProtocol.put(type, new AtomicLong());
            }
        }

        void registerMetrics(MetricsRegistry metricsRegistry) {
            for (ProtocolType type : ProtocolType.valuesAsSet()) {
                metricsRegistry.registerStaticProbe(this, "tcp.bytesReceived." + type.name(), ProbeLevel.INFO, source -> this.bytesReceivedPerProtocol.get((Object)type).get());
                metricsRegistry.registerStaticProbe(this, "tcp.bytesSend." + type.name(), ProbeLevel.INFO, source -> this.bytesSentPerProtocol.get((Object)type).get());
            }
        }

        @Override
        public void run() {
            for (ProtocolType type : ProtocolType.valuesAsSet()) {
                long bytesReceived = 0L;
                long bytesSent = 0L;
                for (EndpointManager endpointManager : this.endpointManagers.values()) {
                    TcpIpEndpointManager tcpIpEndpointManager = (TcpIpEndpointManager)endpointManager;
                    tcpIpEndpointManager.refreshNetworkStats();
                    if (type != tcpIpEndpointManager.getEndpointQualifier().getType()) continue;
                    bytesReceived += tcpIpEndpointManager.getNetworkStats().getBytesReceived();
                    bytesSent += tcpIpEndpointManager.getNetworkStats().getBytesSent();
                }
                this.bytesReceivedPerProtocol.get((Object)type).lazySet(bytesReceived);
                this.bytesSentPerProtocol.get((Object)type).lazySet(bytesSent);
            }
        }
    }
}

