/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.function;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.function.BinaryOperator;

@FunctionalInterface
public interface BinaryOperatorEx<T>
extends BinaryOperator<T>,
Serializable {
    public T applyEx(T var1, T var2) throws Exception;

    @Override
    default public T apply(T t1, T t2) {
        try {
            return this.applyEx(t1, t2);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> BinaryOperatorEx<T> minBy(Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator, "comparator");
        return (l, r) -> comparator.compare(l, r) <= 0 ? l : r;
    }

    public static <T> BinaryOperatorEx<T> maxBy(Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator, "comparator");
        return (l, r) -> comparator.compare(l, r) >= 0 ? l : r;
    }
}

