/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.function;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;
import java.util.function.Consumer;

@FunctionalInterface
public interface ConsumerEx<T>
extends Consumer<T>,
Serializable {
    public void acceptEx(T var1) throws Exception;

    @Override
    default public void accept(T t) {
        try {
            this.acceptEx(t);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    default public ConsumerEx<T> andThen(ConsumerEx<? super T> after) {
        Preconditions.checkNotNull(after, "after");
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    public static <T> ConsumerEx<T> noop() {
        return x -> {};
    }
}

