/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.EntryLoader;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.mapstore.AbstractMapDataStore;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.writebehind.BoundedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.TxnReservedCapacityCounter;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueues;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntries;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.map.impl.operation.NotifyMapFlushOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class WriteBehindStore
extends AbstractMapDataStore<Data, Object> {
    private static final DelayedEntry TRANSIENT = DelayedEntries.emptyDelayedEntry();
    private final AtomicLong sequence = new AtomicLong(0L);
    private final boolean coalesce;
    private final int partitionId;
    private final String mapName;
    private final InMemoryFormat inMemoryFormat;
    private final OperationService operationService;
    private final Queue<Sequence> flushSequences = new ConcurrentLinkedQueue<Sequence>();
    private final ConcurrentMap<Data, DelayedEntry> stagingArea = new ConcurrentHashMap<Data, DelayedEntry>();
    private final TxnReservedCapacityCounter txnReservedCapacityCounter;
    private WriteBehindProcessor writeBehindProcessor;
    private WriteBehindQueue<DelayedEntry> writeBehindQueue;

    public WriteBehindStore(MapStoreContext mapStoreContext, int partitionId, WriteBehindProcessor writeBehindProcessor) {
        super(mapStoreContext);
        this.partitionId = partitionId;
        this.inMemoryFormat = WriteBehindStore.getInMemoryFormat(mapStoreContext);
        this.coalesce = mapStoreContext.getMapStoreConfig().isWriteCoalescing();
        this.mapName = mapStoreContext.getMapName();
        this.operationService = this.nodeEngine.getOperationService();
        this.writeBehindQueue = this.coalesce ? WriteBehindQueues.createDefaultWriteBehindQueue() : WriteBehindQueues.createBoundedWriteBehindQueue(mapStoreContext);
        this.writeBehindProcessor = writeBehindProcessor;
        this.txnReservedCapacityCounter = this.initTxnReservedCapacityCounter();
    }

    private TxnReservedCapacityCounter initTxnReservedCapacityCounter() {
        BoundedWriteBehindQueue unwrapped = this.writeBehindQueue.unwrap(BoundedWriteBehindQueue.class);
        return unwrapped != null ? unwrapped.getTxnReservedCapacityCounter() : TxnReservedCapacityCounter.EMPTY_COUNTER;
    }

    @Override
    public TxnReservedCapacityCounter getTxnReservedCapacityCounter() {
        return this.txnReservedCapacityCounter;
    }

    @Override
    public Object add(Data key, Object value, long expirationTime, long now, UUID transactionId) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            value = this.toHeapData(value);
            key = this.toHeapData(key);
        }
        if (!this.coalesce && InMemoryFormat.OBJECT == this.inMemoryFormat) {
            value = this.toHeapData(value);
        }
        expirationTime = this.getUserExpirationTime(expirationTime);
        this.add(DelayedEntries.newAddedDelayedEntry(key, value, expirationTime, now, this.partitionId, transactionId));
        return value;
    }

    @Override
    public void addForcibly(DelayedEntry<Data, Object> delayedEntry) {
        this.writeBehindQueue.addLast(delayedEntry, true);
        this.stagingArea.put(delayedEntry.getKey(), delayedEntry);
        delayedEntry.setSequence(this.sequence.incrementAndGet());
    }

    public void add(DelayedEntry<Data, Object> delayedEntry) {
        this.writeBehindQueue.addLast(delayedEntry, false);
        this.stagingArea.put(delayedEntry.getKey(), delayedEntry);
        delayedEntry.setSequence(this.sequence.incrementAndGet());
    }

    @Override
    public void addTransient(Data key, long now) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toHeapData(key);
        }
        this.stagingArea.put(key, TRANSIENT);
    }

    @Override
    public Object addBackup(Data key, Object value, long expirationTime, long time, UUID transactionId) {
        return this.add(key, value, expirationTime, time, transactionId);
    }

    @Override
    public void remove(Data key, long now, UUID transactionId) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toHeapData(key);
        }
        this.add(DelayedEntries.newDeletedEntry(key, now, this.partitionId, transactionId));
    }

    @Override
    public void removeBackup(Data key, long time, UUID transactionId) {
        this.remove(key, time, transactionId);
    }

    @Override
    public void reset() {
        this.writeBehindQueue.clear();
        this.stagingArea.clear();
        this.sequence.set(0L);
        this.flushSequences.clear();
    }

    @Override
    public Object load(Data key) {
        DelayedEntry delayedEntry = this.getFromStagingArea(key);
        if (delayedEntry == null) {
            return this.getStore().load(this.toObject(key));
        }
        if (this.isWithExpirationTime() && delayedEntry.getValue() != null) {
            return new EntryLoader.MetadataAwareValue<Object>(this.toObject(delayedEntry.getValue()), delayedEntry.getExpirationTime());
        }
        return this.toObject(delayedEntry.getValue());
    }

    @Override
    public Map loadAll(Collection keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Data, Object> map = MapUtil.createHashMap(keys.size());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Data dataKey = this.toHeapData(key);
            DelayedEntry delayedEntry = this.getFromStagingArea(dataKey);
            if (delayedEntry == null) continue;
            Object value = delayedEntry.getValue();
            if (value != null) {
                if (this.isWithExpirationTime()) {
                    map.put(dataKey, new EntryLoader.MetadataAwareValue<Object>(this.toObject(value), delayedEntry.getExpirationTime()));
                } else {
                    map.put(dataKey, this.toObject(value));
                }
            }
            iterator.remove();
        }
        map.putAll(super.loadAll(keys));
        return map;
    }

    @Override
    public boolean loadable(Data key) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toHeapData(key);
        }
        return !this.writeBehindQueue.contains(DelayedEntries.newAddedDelayedEntry(key));
    }

    @Override
    public int notFinishedOperationsCount() {
        return this.writeBehindQueue.size();
    }

    @Override
    public Object flush(Data key, Object value, boolean backup) {
        DelayedEntry delayedEntry;
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toHeapData(key);
            value = this.toHeapData(value);
        }
        if ((delayedEntry = (DelayedEntry)this.stagingArea.get(key)) == TRANSIENT) {
            this.stagingArea.remove(key);
            return null;
        }
        if (this.writeBehindQueue.size() == 0 || !this.writeBehindQueue.contains(DelayedEntries.newNullEntry(key))) {
            return null;
        }
        this.addAndGetSequence(false);
        return value;
    }

    @Override
    public long softFlush() {
        int size = this.writeBehindQueue.size();
        if (size == 0) {
            return 0L;
        }
        return this.addAndGetSequence(true);
    }

    private long addAndGetSequence(boolean fullFlush) {
        Sequence sequence = new Sequence(this.sequence.get(), fullFlush);
        this.flushSequences.add(sequence);
        return sequence.getSequence();
    }

    @Override
    public void hardFlush() {
        if (this.writeBehindQueue.size() == 0) {
            return;
        }
        this.writeBehindProcessor.flush(this.writeBehindQueue);
    }

    public WriteBehindQueue<DelayedEntry> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    public void setSequence(long newSequence) {
        this.sequence.set(newSequence);
    }

    public void notifyFlush() {
        long nextSequenceNumber = this.sequence.get() + 1L;
        DelayedEntry firstEntry = this.writeBehindQueue.peek();
        if (firstEntry == null) {
            if (!this.flushSequences.isEmpty()) {
                this.findAwaitingFlushesAndSendNotification(nextSequenceNumber);
            }
        } else {
            this.findAwaitingFlushesAndSendNotification(firstEntry.getSequence());
        }
    }

    private void findAwaitingFlushesAndSendNotification(long lastSequenceInQueue) {
        int maxIterationCount = 100;
        Iterator iterator = this.flushSequences.iterator();
        int iterationCount = 0;
        while (iterator.hasNext()) {
            Sequence flushSequence = (Sequence)iterator.next();
            if (flushSequence.getSequence() < lastSequenceInQueue) {
                iterator.remove();
                this.executeNotifyOperation(flushSequence);
            }
            if (++iterationCount != 100) continue;
            break;
        }
    }

    private void executeNotifyOperation(Sequence flushSequence) {
        if (!flushSequence.isFullFlush() || !this.nodeEngine.getPartitionService().isPartitionOwner(this.partitionId)) {
            return;
        }
        NotifyMapFlushOperation operation = new NotifyMapFlushOperation(this.mapName, flushSequence.getSequence());
        operation.setServiceName("hz:impl:mapService").setNodeEngine(this.nodeEngine).setPartitionId(this.partitionId).setCallerUuid(this.nodeEngine.getLocalMember().getUuid()).setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        this.operationService.execute(operation);
    }

    protected void removeFromStagingArea(DelayedEntry delayedEntry) {
        if (delayedEntry == null) {
            return;
        }
        Data key = (Data)delayedEntry.getKey();
        this.stagingArea.remove(key, delayedEntry);
    }

    private DelayedEntry getFromStagingArea(Data key) {
        DelayedEntry delayedEntry = (DelayedEntry)this.stagingArea.get(key);
        if (delayedEntry == null || delayedEntry == TRANSIENT) {
            return null;
        }
        return delayedEntry;
    }

    public Queue<Sequence> getFlushSequences() {
        return this.flushSequences;
    }

    public long getSequenceToFlush() {
        int maxIterationCount = 100;
        Iterator iterator = this.flushSequences.iterator();
        long sequenceNumber = 0L;
        int iterationCount = 0;
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            sequenceNumber = sequence.getSequence();
            if (++iterationCount != 100) continue;
            break;
        }
        return sequenceNumber;
    }

    public void setFlushSequences(Queue<Sequence> flushSequences) {
        this.flushSequences.addAll(flushSequences);
    }

    private static InMemoryFormat getInMemoryFormat(MapStoreContext mapStoreContext) {
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        Config config = nodeEngine.getConfig();
        String mapName = mapStoreContext.getMapName();
        MapConfig mapConfig = config.findMapConfig(mapName);
        return mapConfig.getInMemoryFormat();
    }

    public static class Sequence {
        private final long sequence;
        private final boolean fullFlush;

        public Sequence(long sequence, boolean fullFlush) {
            this.sequence = sequence;
            this.fullFlush = fullFlush;
        }

        public long getSequence() {
            return this.sequence;
        }

        public boolean isFullFlush() {
            return this.fullFlush;
        }
    }
}

