/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writethrough;

import com.hazelcast.map.EntryLoader;
import com.hazelcast.map.impl.mapstore.AbstractMapDataStore;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.nio.serialization.Data;
import java.util.UUID;

public class WriteThroughStore
extends AbstractMapDataStore<Data, Object> {
    public WriteThroughStore(MapStoreContext mapStoreContext) {
        super(mapStoreContext);
    }

    @Override
    public Object add(Data key, Object value, long expirationTime, long time, UUID transactionId) {
        Object objectKey = this.toObject(key);
        Object objectValue = this.toObject(value);
        if (this.getStore().isWithExpirationTime()) {
            expirationTime = this.getUserExpirationTime(expirationTime);
            this.getStore().store(objectKey, new EntryLoader.MetadataAwareValue<Object>(objectValue, expirationTime));
        } else {
            this.getStore().store(objectKey, objectValue);
        }
        return this.getStore().isPostProcessingMapStore() ? objectValue : value;
    }

    @Override
    public void addForcibly(DelayedEntry delayedEntry) {
        throw new IllegalStateException("No addForcibly call is expected from a write-through store!");
    }

    @Override
    public void addTransient(Data key, long now) {
    }

    @Override
    public Object addBackup(Data key, Object value, long expirationTime, long time, UUID transactionId) {
        return value;
    }

    @Override
    public void remove(Data key, long time, UUID transactionId) {
        this.getStore().delete(this.toObject(key));
    }

    @Override
    public void removeBackup(Data key, long time, UUID transactionId) {
    }

    @Override
    public void reset() {
    }

    @Override
    public Object load(Data key) {
        return this.getStore().load(this.toObject(key));
    }

    @Override
    public boolean loadable(Data key) {
        return true;
    }

    @Override
    public long softFlush() {
        return 0L;
    }

    @Override
    public void hardFlush() {
    }

    @Override
    public Object flush(Data key, Object value, boolean backup) {
        return value;
    }

    @Override
    public int notFinishedOperationsCount() {
        return 0;
    }
}

