/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.operation.AddIndexBackupOperation;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStoreAdapter;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.Iterator;

public class AddIndexOperation
extends MapOperation
implements PartitionAwareOperation,
MutatingOperation,
BackupAwareOperation {
    private IndexConfig config;

    public AddIndexOperation() {
    }

    public AddIndexOperation(String name, IndexConfig config) {
        super(name);
        this.config = IndexUtils.validateAndNormalize(name, config);
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new AddIndexBackupOperation(this.name, this.config);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void runInternal() {
        int partitionId = this.getPartitionId();
        Indexes indexes = this.mapContainer.getIndexes(partitionId);
        RecordStoreAdapter recordStoreAdapter = new RecordStoreAdapter(this.recordStore);
        InternalIndex index = indexes.addOrGetIndex(this.config, indexes.isGlobal() ? null : recordStoreAdapter);
        if (index.hasPartitionIndexed(partitionId)) {
            return;
        }
        long now = this.getNow();
        Iterator<Record> iterator = this.recordStore.iterator(now, false);
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data key = record.getKey();
            Object value = Records.getValueOrCachedValue(record, serializationService);
            QueryableEntry queryEntry = this.mapContainer.newQueryEntry(key, value);
            queryEntry.setRecord(record);
            queryEntry.setStoreAdapter(recordStoreAdapter);
            index.putEntry(queryEntry, null, Index.OperationSource.USER);
        }
        index.markPartitionAsIndexed(partitionId);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.config);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.config = (IndexConfig)in.readObject();
    }

    @Override
    public int getClassId() {
        return 41;
    }
}

