/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;

public abstract class BaseRemoveOperation
extends LockAwareOperation
implements BackupAwareOperation,
MutatingOperation {
    protected transient Data dataOldValue;

    public BaseRemoveOperation() {
    }

    public BaseRemoveOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    @Override
    protected void afterRunInternal() {
        this.mapServiceContext.interceptAfterRemove(this.name, this.dataOldValue);
        this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, EntryEventType.REMOVED, this.dataKey, this.dataOldValue, null);
        this.invalidateNearCache(this.dataKey);
        this.publishWanRemove(this.dataKey);
        this.evict(this.dataKey);
    }

    @Override
    public Object getResponse() {
        return this.dataOldValue;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveBackupOperation(this.name, this.dataKey, this.disableWanReplicationEvent());
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }
}

