/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidator;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespaceAware;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.writebehind.TxnReservedCapacityCounter;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.operation.WithForcedEviction;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.List;
import java.util.logging.Level;

public abstract class MapOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable,
ServiceNamespaceAware {
    private static final boolean ASSERTION_ENABLED = MapOperation.class.desiredAssertionStatus();
    protected transient MapService mapService;
    protected transient RecordStore recordStore;
    protected transient MapContainer mapContainer;
    protected transient MapServiceContext mapServiceContext;
    protected transient MapEventPublisher mapEventPublisher;
    protected transient boolean createRecordStoreOnDemand = true;
    protected transient boolean disposeDeferredBlocks = true;
    private transient boolean canPublishWanEvent;

    public MapOperation() {
    }

    public MapOperation(String name) {
        this.name = name;
    }

    @Override
    public final void beforeRun() throws Exception {
        super.beforeRun();
        this.mapService = (MapService)this.getService();
        this.mapServiceContext = this.mapService.getMapServiceContext();
        this.mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        try {
            this.recordStore = this.getRecordStoreOrNull();
            this.mapContainer = this.recordStore == null ? this.mapServiceContext.getMapContainer(this.name) : this.recordStore.getMapContainer();
        }
        catch (Throwable t) {
            this.disposeDeferredBlocks();
            throw ExceptionUtil.rethrow(t, Exception.class);
        }
        this.canPublishWanEvent = this.canPublishWanEvent(this.mapContainer);
        this.assertNativeMapOnPartitionThread();
        this.innerBeforeRun();
    }

    protected void innerBeforeRun() throws Exception {
    }

    @Override
    public final void run() {
        try {
            this.runInternal();
        }
        catch (NativeOutOfMemoryError e) {
            WithForcedEviction.rerun(this);
        }
    }

    protected void runInternal() {
    }

    @Override
    public final void afterRun() throws Exception {
        this.afterRunInternal();
        this.disposeDeferredBlocks();
        super.afterRun();
    }

    private void assertNativeMapOnPartitionThread() {
        if (!ASSERTION_ENABLED) {
            return;
        }
        assert (this.mapContainer.getMapConfig().getInMemoryFormat() != InMemoryFormat.NATIVE || this.getPartitionId() != -1) : "Native memory backed map operations are not allowed to run on GENERIC_PARTITION_ID";
    }

    protected void afterRunInternal() {
    }

    ILogger logger() {
        return this.getLogger();
    }

    protected final CallerProvenance getCallerProvenance() {
        return this.disableWanReplicationEvent() ? CallerProvenance.WAN : CallerProvenance.NOT_WAN;
    }

    private RecordStore getRecordStoreOrNull() {
        int partitionId = this.getPartitionId();
        if (partitionId == -1) {
            return null;
        }
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        if (this.createRecordStoreOnDemand) {
            return partitionContainer.getRecordStore(this.name);
        }
        return partitionContainer.getExistingRecordStore(this.name);
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        this.disposeDeferredBlocks();
        super.onExecutionFailure(e);
    }

    @Override
    public void logError(Throwable e) {
        ILogger logger = this.getLogger();
        if (e instanceof NativeOutOfMemoryError) {
            Level level = this instanceof BackupOperation ? Level.FINEST : Level.WARNING;
            logger.log(level, "Cannot complete operation! -> " + e.getMessage());
        } else {
            this.disposeDeferredBlocks();
            super.logError(e);
        }
    }

    void disposeDeferredBlocks() {
        if (!this.disposeDeferredBlocks) {
            return;
        }
        int partitionId = this.getPartitionId();
        if (partitionId == -1) {
            return;
        }
        MapService service = (MapService)this.getService();
        RecordStore recordStore = service.getMapServiceContext().getExistingRecordStore(partitionId, this.name);
        if (recordStore != null) {
            recordStore.disposeDeferredBlocks();
        }
    }

    private boolean canPublishWanEvent(MapContainer mapContainer) {
        boolean canPublishWanEvent;
        boolean bl = canPublishWanEvent = mapContainer.isWanReplicationEnabled() && !this.disableWanReplicationEvent();
        if (canPublishWanEvent) {
            mapContainer.getWanReplicationDelegate().doPrepublicationChecks();
        }
        return canPublishWanEvent;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    public boolean isPostProcessing(RecordStore recordStore) {
        MapDataStore<Data, Object> mapDataStore = recordStore.getMapDataStore();
        return mapDataStore.isPostProcessingMapStore() || this.mapServiceContext.hasInterceptor(this.name);
    }

    public void setThreadId(long threadId) {
        throw new UnsupportedOperationException();
    }

    public long getThreadId() {
        throw new UnsupportedOperationException();
    }

    protected final void invalidateNearCache(List<Data> keys) {
        if (!this.mapContainer.hasInvalidationListener() || CollectionUtil.isEmpty(keys)) {
            return;
        }
        Invalidator invalidator = this.getNearCacheInvalidator();
        for (Data key : keys) {
            invalidator.invalidateKey(key, this.name, this.getCallerUuid());
        }
    }

    public final void invalidateNearCache(Data key) {
        if (!this.mapContainer.hasInvalidationListener() || key == null) {
            return;
        }
        Invalidator invalidator = this.getNearCacheInvalidator();
        invalidator.invalidateKey(key, this.name, this.getCallerUuid());
    }

    protected final void invalidateAllKeysInNearCaches() {
        if (this.mapContainer.hasInvalidationListener()) {
            int partitionId = this.getPartitionId();
            Invalidator invalidator = this.getNearCacheInvalidator();
            if (partitionId == this.getNodeEngine().getPartitionService().getPartitionId(this.name)) {
                invalidator.invalidateAllKeys(this.name, this.getCallerUuid());
            }
            invalidator.resetPartitionMetaData(this.name, this.getPartitionId());
        }
    }

    private Invalidator getNearCacheInvalidator() {
        MapNearCacheManager mapNearCacheManager = this.mapServiceContext.getMapNearCacheManager();
        return mapNearCacheManager.getInvalidator();
    }

    protected final void evict(Data justAddedKey) {
        assert (this.recordStore != null) : "Record-store cannot be null";
        this.recordStore.evictEntries(justAddedKey);
        this.disposeDeferredBlocks();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public ObjectNamespace getServiceNamespace() {
        MapContainer container = this.mapContainer;
        if (container == null) {
            MapService service = (MapService)this.getService();
            container = service.getMapServiceContext().getMapContainer(this.name);
        }
        return container.getObjectNamespace();
    }

    public void setMapService(MapService mapService) {
        this.mapService = mapService;
    }

    public void setMapContainer(MapContainer mapContainer) {
        this.mapContainer = mapContainer;
    }

    protected final void publishWanUpdate(Data dataKey, Object value) {
        this.publishWanUpdateInternal(dataKey, value, false);
    }

    private void publishWanUpdateInternal(Data dataKey, Object value, boolean hasLoadProvenance) {
        if (!this.canPublishWanEvent) {
            return;
        }
        Object record = this.recordStore.getRecord(dataKey);
        if (record == null) {
            return;
        }
        Data dataValue = ToHeapDataConverter.toHeapData(this.mapServiceContext.toData(value));
        EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(ToHeapDataConverter.toHeapData(dataKey), dataValue, record);
        this.mapEventPublisher.publishWanUpdate(this.name, entryView, hasLoadProvenance);
    }

    protected final void publishLoadAsWanUpdate(Data dataKey, Object value) {
        this.publishWanUpdateInternal(dataKey, value, true);
    }

    protected final void publishWanRemove(Data dataKey) {
        if (!this.canPublishWanEvent) {
            return;
        }
        this.mapEventPublisher.publishWanRemove(this.name, ToHeapDataConverter.toHeapData(dataKey));
    }

    protected boolean disableWanReplicationEvent() {
        return false;
    }

    protected final TxnReservedCapacityCounter wbqCapacityCounter() {
        return this.recordStore.getMapDataStore().getTxnReservedCapacityCounter();
    }
}

