/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.operation.AbstractMultipleEntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class PartitionWideEntryBackupOperation
extends AbstractMultipleEntryBackupOperation
implements BackupOperation {
    public PartitionWideEntryBackupOperation() {
    }

    public PartitionWideEntryBackupOperation(String name, EntryProcessor backupProcessor) {
        super(name, backupProcessor);
    }

    @Override
    protected void runInternal() {
        if (this.mapContainer.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE) {
            this.runWithPartitionScanForNative();
        } else {
            this.runWithPartitionScan();
        }
    }

    private void runWithPartitionScan() {
        EntryOperator operator = EntryOperator.operator(this, this.backupProcessor, this.getPredicate());
        Iterator<Record> iterator = this.recordStore.iterator(Clock.currentTimeMillis(), true);
        while (iterator.hasNext()) {
            Record record = iterator.next();
            operator.operateOnKey(record.getKey()).doPostOperateOps();
        }
    }

    protected void runWithPartitionScanForNative() {
        LinkedList<Data> outComes = null;
        EntryOperator operator = EntryOperator.operator(this, this.backupProcessor, this.getPredicate());
        Iterator<Record> iterator = this.recordStore.iterator(Clock.currentTimeMillis(), true);
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data dataKey = ToHeapDataConverter.toHeapData(record.getKey());
            operator.operateOnKey(dataKey);
            EntryEventType eventType = operator.getEventType();
            if (eventType == null) continue;
            if (outComes == null) {
                outComes = new LinkedList<Data>();
            }
            outComes.add(dataKey);
            outComes.add((Data)operator.getOldValue());
            outComes.add((Data)operator.getNewValue());
            outComes.add((Data)((Object)eventType));
        }
        if (outComes != null) {
            do {
                Data dataKey = (Data)outComes.poll();
                Object oldValue = outComes.poll();
                Object newValue = outComes.poll();
                EntryEventType eventType = (EntryEventType)((Object)outComes.poll());
                operator.init(dataKey, oldValue, newValue, null, eventType).doPostOperateOps();
            } while (!outComes.isEmpty());
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.backupProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.backupProcessor);
    }

    @Override
    public int getClassId() {
        return 38;
    }
}

