/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MultipleEntryBackupOperation;
import com.hazelcast.map.impl.operation.PartitionWideEntryBackupOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class PartitionWideEntryOperation
extends MapOperation
implements MutatingOperation,
PartitionAwareOperation,
BackupAwareOperation {
    protected MapEntries responses;
    protected EntryProcessor entryProcessor;
    protected transient EntryOperator operator;
    protected transient Set<Data> keysFromIndex;
    protected transient QueryOptimizer queryOptimizer;

    public PartitionWideEntryOperation() {
    }

    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
        this.keysFromIndex = null;
        this.queryOptimizer = this.mapServiceContext.getQueryOptimizer();
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    protected void runInternal() {
        if (this.mapContainer.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE) {
            this.runForNative();
        } else {
            this.runWithPartitionScan();
        }
    }

    private void runForNative() {
        if (this.runWithIndex()) {
            return;
        }
        this.runWithPartitionScanForNative();
    }

    private boolean runWithIndex() {
        Predicate predicate = this.getPredicate();
        if (predicate == null) {
            return false;
        }
        Indexes indexes = this.mapContainer.getIndexes(this.getPartitionId());
        Set<QueryableEntry> entries = indexes.query(this.queryOptimizer.optimize(predicate, indexes));
        if (entries == null) {
            return false;
        }
        this.responses = new MapEntries(entries.size());
        this.operator = EntryOperator.operator(this, this.entryProcessor, null);
        this.keysFromIndex = new HashSet<Data>(entries.size());
        for (QueryableEntry entry : entries) {
            this.keysFromIndex.add(entry.getKeyData());
            Data response = this.operator.operateOnKey(entry.getKeyData()).doPostOperateOps().getResult();
            if (response == null) continue;
            this.responses.add(entry.getKeyData(), response);
        }
        return true;
    }

    private void runWithPartitionScan() {
        this.responses = new MapEntries(this.recordStore.size());
        this.operator = EntryOperator.operator(this, this.entryProcessor, this.getPredicate());
        Iterator<Record> iterator = this.recordStore.iterator(Clock.currentTimeMillis(), false);
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data dataKey = record.getKey();
            Data response = this.operator.operateOnKey(dataKey).doPostOperateOps().getResult();
            if (response == null) continue;
            this.responses.add(dataKey, response);
        }
    }

    private void runWithPartitionScanForNative() {
        EntryEventType eventType;
        int totalEntryCount = this.recordStore.size();
        this.responses = new MapEntries(totalEntryCount);
        LinkedList<Data> outComes = null;
        this.operator = EntryOperator.operator(this, this.entryProcessor, this.getPredicate());
        Iterator<Record> iterator = this.recordStore.iterator(Clock.currentTimeMillis(), false);
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data dataKey = ToHeapDataConverter.toHeapData(record.getKey());
            Data response = this.operator.operateOnKey(dataKey).getResult();
            if (response != null) {
                this.responses.add(dataKey, response);
            }
            if ((eventType = this.operator.getEventType()) == null) continue;
            if (outComes == null) {
                outComes = new LinkedList<Data>();
            }
            outComes.add(dataKey);
            outComes.add((Data)this.operator.getOldValue());
            outComes.add((Data)this.operator.getNewValue());
            outComes.add((Data)((Object)eventType));
        }
        if (outComes != null) {
            do {
                Data dataKey = (Data)outComes.poll();
                Object oldValue = outComes.poll();
                Object newValue = outComes.poll();
                eventType = (EntryEventType)((Object)outComes.poll());
                this.operator.init(dataKey, oldValue, newValue, null, eventType).doPostOperateOps();
            } while (!outComes.isEmpty());
        }
    }

    @Override
    public Object getResponse() {
        return this.responses;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="backupProcessor can indeed be null so check is not redundant")
    public Operation getBackupOperation() {
        EntryProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        if (backupProcessor == null) {
            return null;
        }
        if (this.keysFromIndex != null) {
            return new MultipleEntryBackupOperation(this.name, this.keysFromIndex, backupProcessor);
        }
        return new PartitionWideEntryBackupOperation(this.name, backupProcessor);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", entryProcessor=").append(this.entryProcessor);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public int getClassId() {
        return 37;
    }
}

