/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;

public class PutBackupOperation
extends MapOperation
implements BackupOperation {
    protected Data dataKey;
    protected Data dataValue;
    protected RecordInfo recordInfo;

    public PutBackupOperation(String name, Data dataKey, Data dataValue, RecordInfo recordInfo) {
        super(name);
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.recordInfo = recordInfo;
    }

    public PutBackupOperation() {
    }

    @Override
    protected void runInternal() {
        Object record = this.recordStore.putBackup(this.dataKey, this.dataValue, this.recordInfo.getTtl(), this.recordInfo.getMaxIdle(), this.isPutTransient(), this.getCallerProvenance());
        Records.applyRecordInfo(record, this.recordInfo);
    }

    protected boolean isPutTransient() {
        return false;
    }

    @Override
    protected void afterRunInternal() {
        this.evict(this.dataKey);
        this.publishWanUpdate(this.dataKey, this.dataValue);
        super.afterRunInternal();
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.dataKey);
        out.writeData(this.dataValue);
        this.recordInfo.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.dataKey = in.readData();
        this.dataValue = in.readData();
        this.recordInfo = new RecordInfo();
        this.recordInfo.readData(in);
    }
}

