/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PutFromLoadAllBackupOperation
extends MapOperation
implements BackupOperation {
    private List<Data> loadingSequence;
    private boolean includesExpirationTime;

    public PutFromLoadAllBackupOperation() {
        this.loadingSequence = Collections.emptyList();
    }

    public PutFromLoadAllBackupOperation(String name, List<Data> loadingSequence, boolean includesExpirationTime) {
        super(name);
        this.loadingSequence = loadingSequence;
        this.includesExpirationTime = includesExpirationTime;
    }

    @Override
    protected void runInternal() {
        List<Data> keyValueSequence = this.loadingSequence;
        if (keyValueSequence == null || keyValueSequence.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < keyValueSequence.size()) {
            Data key = keyValueSequence.get(i++);
            Data value = keyValueSequence.get(i++);
            Object object = this.mapServiceContext.toObject(value);
            if (this.includesExpirationTime) {
                long expirationTime = (Long)this.mapServiceContext.toObject(keyValueSequence.get(i++));
                this.recordStore.putFromLoadBackup(key, object, expirationTime);
            } else {
                this.recordStore.putFromLoadBackup(key, object);
            }
            if (!this.recordStore.existInMemory(key)) continue;
            this.publishLoadAsWanUpdate(key, value);
        }
    }

    @Override
    protected void afterRunInternal() {
        this.evict(null);
        super.afterRunInternal();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.includesExpirationTime);
        List<Data> keyValueSequence = this.loadingSequence;
        int size = keyValueSequence.size();
        out.writeInt(size);
        for (Data data : keyValueSequence) {
            out.writeData(data);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.includesExpirationTime = in.readBoolean();
        int size = in.readInt();
        if (size < 1) {
            this.loadingSequence = Collections.emptyList();
        } else {
            ArrayList<Data> tmpLoadingSequence = new ArrayList<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = in.readData();
                tmpLoadingSequence.add(data);
            }
            this.loadingSequence = tmpLoadingSequence;
        }
    }

    @Override
    public int getClassId() {
        return 56;
    }
}

