/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public final class WithForcedEviction {
    public static final int DEFAULT_FORCED_EVICTION_RETRY_COUNT = 5;
    public static final String PROP_FORCED_EVICTION_RETRY_COUNT = "hazelcast.internal.forced.eviction.retry.count";
    public static final HazelcastProperty FORCED_EVICTION_RETRY_COUNT = new HazelcastProperty("hazelcast.internal.forced.eviction.retry.count", 5);

    private WithForcedEviction() {
    }

    static void rerun(MapOperation mapOperation) {
        try {
            WithForcedEviction.rerunWithForcedEviction(mapOperation);
        }
        catch (NativeOutOfMemoryError e) {
            mapOperation.disposeDeferredBlocks();
            throw e;
        }
    }

    private static void rerunWithForcedEviction(MapOperation mapOperation) {
        int i;
        ILogger logger = mapOperation.logger();
        int forcedEvictionRetryCount = WithForcedEviction.getRetryCount(mapOperation);
        for (i = 0; i < forcedEvictionRetryCount; ++i) {
            try {
                if (logger.isFineEnabled()) {
                    logger.fine(String.format("Applying forced eviction on current RecordStore (map %s, partitionId: %d)!", mapOperation.getName(), mapOperation.getPartitionId()));
                }
                WithForcedEviction.forceEviction(mapOperation.recordStore);
                mapOperation.runInternal();
                return;
            }
            catch (NativeOutOfMemoryError e) {
                EmptyStatement.ignore(e);
                continue;
            }
        }
        for (i = 0; i < forcedEvictionRetryCount; ++i) {
            try {
                if (logger.isFineEnabled()) {
                    logger.fine(String.format("Applying forced eviction on other RecordStores owned by the same partition thread (map %s, partitionId: %d", mapOperation.getName(), mapOperation.getPartitionId()));
                }
                WithForcedEviction.forceEvictionOnOthers(mapOperation);
                mapOperation.runInternal();
                return;
            }
            catch (NativeOutOfMemoryError e) {
                EmptyStatement.ignore(e);
                continue;
            }
        }
        WithForcedEviction.evictAllAndRetry(logger, mapOperation);
    }

    private static void evictAllAndRetry(ILogger logger, MapOperation mapOperation) {
        boolean isBackup = mapOperation instanceof BackupOperation;
        RecordStore recordStore = mapOperation.recordStore;
        if (recordStore != null) {
            try {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Evicting all entries in current RecordStores because forced eviction was not enough!");
                }
                WithForcedEviction.evictAllThenDispose(recordStore, isBackup);
                mapOperation.runInternal();
                return;
            }
            catch (NativeOutOfMemoryError e) {
                EmptyStatement.ignore(e);
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Evicting all entries in other RecordStores owned by the same partition thread because forced eviction was not enough!");
        }
        WithForcedEviction.evictAll(mapOperation, isBackup);
        mapOperation.runInternal();
    }

    private static void forceEviction(RecordStore recordStore) {
        if (recordStore == null) {
            return;
        }
        MapContainer mapContainer = recordStore.getMapContainer();
        MapConfig mapConfig = mapContainer.getMapConfig();
        if (mapConfig.getInMemoryFormat() == InMemoryFormat.NATIVE && mapConfig.getEvictionPolicy() != EvictionPolicy.NONE) {
            Evictor evictor = mapContainer.getEvictor();
            evictor.forceEvict(recordStore);
        }
    }

    private static void forceEvictionOnOthers(MapOperation mapOperation) {
        NodeEngine nodeEngine = mapOperation.getNodeEngine();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        OperationService operationService = nodeEngine.getOperationService();
        int threadCount = operationService.getPartitionThreadCount();
        int mod = mapOperation.getPartitionId() % threadCount;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            if (partitionId % threadCount != mod) continue;
            ConcurrentMap<String, RecordStore> maps = WithForcedEviction.getRecordStoresInThisPartition(mapOperation, partitionId);
            for (RecordStore recordStore : maps.values()) {
                WithForcedEviction.forceEviction(recordStore);
            }
        }
    }

    private static void evictAll(MapOperation mapOperation, boolean isBackup) {
        NodeEngine nodeEngine = mapOperation.getNodeEngine();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        OperationService operationService = nodeEngine.getOperationService();
        int threadCount = operationService.getPartitionThreadCount();
        int mod = mapOperation.getPartitionId() % threadCount;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            if (partitionId % threadCount != mod) continue;
            ConcurrentMap<String, RecordStore> maps = WithForcedEviction.getRecordStoresInThisPartition(mapOperation, partitionId);
            for (RecordStore recordStore : maps.values()) {
                MapConfig mapConfig = recordStore.getMapContainer().getMapConfig();
                if (mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE || mapConfig.getEvictionPolicy() == EvictionPolicy.NONE) continue;
                WithForcedEviction.evictAllThenDispose(recordStore, isBackup);
            }
        }
    }

    private static ConcurrentMap<String, RecordStore> getRecordStoresInThisPartition(MapOperation mapOperation, int partitionId) {
        MapServiceContext mapServiceContext = mapOperation.mapServiceContext;
        PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getMaps();
    }

    private static void evictAllThenDispose(RecordStore recordStore, boolean isBackup) {
        recordStore.evictAll(isBackup);
        recordStore.disposeDeferredBlocks();
    }

    private static int getRetryCount(Operation operation) {
        HazelcastProperties properties = operation.getNodeEngine().getProperties();
        return properties.getInteger(FORCED_EVICTION_RETRY_COUNT);
    }
}

