/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.UUID;

public class TxnRollbackBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    private UUID lockOwner;
    private UUID transactionId;

    protected TxnRollbackBackupOperation(String name, Data dataKey, UUID lockOwner, long lockThreadId, UUID transactionId) {
        super(name, dataKey);
        this.lockOwner = lockOwner;
        this.threadId = lockThreadId;
        this.transactionId = transactionId;
    }

    public TxnRollbackBackupOperation() {
    }

    @Override
    protected void runInternal() {
        this.wbqCapacityCounter().decrement(this.transactionId);
        if (this.recordStore.isLocked(this.getKey()) && !this.recordStore.unlock(this.getKey(), this.lockOwner, this.threadId, this.getCallId())) {
            throw new TransactionException("Lock is not owned by the transaction! Owner: " + this.recordStore.getLockOwnerInfo(this.getKey()));
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.lockOwner);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.lockOwner = UUIDSerializationUtil.readUUID(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 68;
    }
}

