/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.operation.PutBackupOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.UUID;

public class TxnSetBackupOperation
extends PutBackupOperation {
    private UUID transactionId;

    public TxnSetBackupOperation() {
    }

    public TxnSetBackupOperation(String name, Data dataKey, Data dataValue, RecordInfo recordInfo, UUID transactionId) {
        super(name, dataKey, dataValue, recordInfo);
        this.transactionId = transactionId;
    }

    @Override
    protected void runInternal() {
        Object record = this.recordStore.putBackupTxn(this.dataKey, this.dataValue, this.recordInfo.getTtl(), this.recordInfo.getMaxIdle(), this.isPutTransient(), this.getCallerProvenance(), this.transactionId);
        Records.applyRecordInfo(record, this.recordInfo);
        this.recordStore.forceUnlock(this.dataKey);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 141;
    }
}

