/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class IndexUtils {
    public static final int MAX_ATTRIBUTES = 255;
    private static final Pattern THIS_PATTERN = Pattern.compile("^this\\.");

    private IndexUtils() {
    }

    public static IndexConfig validateAndNormalize(String mapName, IndexConfig config) {
        assert (config != null);
        List<String> originalAttributeNames = config.getAttributes();
        if (originalAttributeNames.isEmpty()) {
            throw new IllegalArgumentException("Index must have at least one attribute: " + config);
        }
        if (originalAttributeNames.size() > 255) {
            throw new IllegalArgumentException("Index cannot have more than 255 attributes: " + config);
        }
        ArrayList<String> normalizedAttributeNames = new ArrayList<String>(originalAttributeNames.size());
        for (String originalAttributeName : originalAttributeNames) {
            IndexUtils.validateAttribute(config, originalAttributeName);
            originalAttributeName = originalAttributeName.trim();
            String normalizedAttributeName = IndexUtils.canonicalizeAttribute(originalAttributeName);
            assert (!normalizedAttributeName.isEmpty());
            int existingIdx = normalizedAttributeNames.indexOf(normalizedAttributeName);
            if (existingIdx != -1) {
                String duplicateOriginalAttributeName = originalAttributeNames.get(existingIdx);
                if (duplicateOriginalAttributeName.equals(originalAttributeName)) {
                    throw new IllegalArgumentException("Duplicate attribute name [attributeName=" + originalAttributeName + ", indexConfig=" + config + ']');
                }
                throw new IllegalArgumentException("Duplicate attribute names [attributeName1=" + duplicateOriginalAttributeName + ", attributeName2=" + originalAttributeName + ", indexConfig=" + config + ']');
            }
            normalizedAttributeNames.add(normalizedAttributeName);
        }
        String name = config.getName();
        if (name != null && name.trim().isEmpty()) {
            name = null;
        }
        return IndexUtils.buildNormalizedConfig(mapName, config.getType(), name, normalizedAttributeNames);
    }

    private static IndexConfig buildNormalizedConfig(String mapName, IndexType indexType, String indexName, List<String> normalizedAttributeNames) {
        IndexConfig newConfig = new IndexConfig().setType(indexType);
        StringBuilder nameBuilder = indexName == null ? new StringBuilder(mapName + "_" + IndexUtils.getIndexTypeName(indexType)) : null;
        for (String normalizedAttributeName : normalizedAttributeNames) {
            newConfig.addAttribute(normalizedAttributeName);
            if (nameBuilder == null) continue;
            nameBuilder.append("_").append(normalizedAttributeName);
        }
        if (nameBuilder != null) {
            indexName = nameBuilder.toString();
        }
        newConfig.setName(indexName);
        return newConfig;
    }

    public static void validateAttribute(IndexConfig config, String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("Attribute name cannot be null: " + config);
        }
        String attributeName0 = attributeName.trim();
        if (attributeName0.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be empty: " + config);
        }
        if (attributeName0.endsWith(".")) {
            throw new IllegalArgumentException("Attribute name cannot end with dot [config=" + config + ", attribute=" + attributeName + ']');
        }
    }

    public static void validateAttribute(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("Attribute name cannot be null.");
        }
        String attributeName0 = attributeName.trim();
        if (attributeName0.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be empty.");
        }
        if (attributeName0.endsWith(".")) {
            throw new IllegalArgumentException("Attribute name cannot end with dot: " + attributeName);
        }
    }

    public static String canonicalizeAttribute(String attribute) {
        return THIS_PATTERN.matcher(attribute).replaceFirst("");
    }

    public static String[] getComponents(IndexConfig config) {
        assert (config != null);
        List<String> attributes = config.getAttributes();
        String[] res = new String[attributes.size()];
        for (int i = 0; i < attributes.size(); ++i) {
            res[i] = attributes.get(i);
        }
        return res;
    }

    public static IndexConfig createIndexConfig(IndexType type, String ... attributes) {
        IndexConfig res = new IndexConfig();
        res.setType(type);
        Preconditions.checkNotNull(attributes, "Index attributes cannot be null.");
        for (String attribute : attributes) {
            res.addAttribute(attribute);
        }
        return res;
    }

    public static IndexConfig createTestIndexConfig(IndexType type, String ... attributes) {
        IndexConfig res = IndexUtils.createIndexConfig(type, attributes);
        return IndexUtils.validateAndNormalize(UuidUtil.newUnsecureUUID().toString(), res);
    }

    public static void generateXml(ConfigXmlGenerator.XmlGenerator gen, List<IndexConfig> indexConfigs) {
        if (indexConfigs.isEmpty()) {
            return;
        }
        gen.open("indexes", new Object[0]);
        for (IndexConfig indexCfg : indexConfigs) {
            if (indexCfg.getName() != null) {
                gen.open("index", "name", indexCfg.getName(), "type", indexCfg.getType().name());
            } else {
                gen.open("index", "type", indexCfg.getType().name());
            }
            gen.open("attributes", new Object[0]);
            for (String attribute : indexCfg.getAttributes()) {
                gen.node("attribute", attribute, new Object[0]);
            }
            gen.close();
            gen.close();
        }
        gen.close();
    }

    public static IndexConfig getIndexConfigFromXml(Node indexNode, boolean domLevel3) {
        NamedNodeMap attrs = indexNode.getAttributes();
        String name = DomConfigHelper.getTextContent(attrs.getNamedItem("name"), domLevel3);
        if (name.isEmpty()) {
            name = null;
        }
        String typeStr = DomConfigHelper.getTextContent(attrs.getNamedItem("type"), domLevel3);
        IndexType type = IndexUtils.getIndexTypeFromXmlName(typeStr);
        IndexConfig res = new IndexConfig().setName(name).setType(type);
        for (Node attributesNode : DomConfigHelper.childElements(indexNode)) {
            if (!"attributes".equals(DomConfigHelper.cleanNodeName(attributesNode))) continue;
            for (Node attributeNode : DomConfigHelper.childElements(attributesNode)) {
                if (!"attribute".equals(DomConfigHelper.cleanNodeName(attributeNode))) continue;
                String attribute = DomConfigHelper.getTextContent(attributeNode, domLevel3);
                res.addAttribute(attribute);
            }
        }
        return res;
    }

    public static IndexType getIndexTypeFromXmlName(String typeStr) {
        if (typeStr == null || typeStr.isEmpty()) {
            typeStr = IndexConfig.DEFAULT_TYPE.name();
        }
        if ((typeStr = typeStr.toLowerCase()).equals(IndexType.SORTED.name().toLowerCase())) {
            return IndexType.SORTED;
        }
        if (typeStr.equals(IndexType.HASH.name().toLowerCase())) {
            return IndexType.HASH;
        }
        throw new IllegalArgumentException("Unsupported index type: " + typeStr);
    }

    public static IndexConfig getIndexConfigFromYaml(Node indexNode, boolean domLevel3) {
        IndexType type;
        String typeStr;
        NamedNodeMap attrs = indexNode.getAttributes();
        String name = DomConfigHelper.getTextContent(attrs.getNamedItem("name"), domLevel3);
        if (name.isEmpty()) {
            name = null;
        }
        if ((typeStr = DomConfigHelper.getTextContent(attrs.getNamedItem("type"), domLevel3)).isEmpty()) {
            typeStr = IndexConfig.DEFAULT_TYPE.name();
        }
        if ((typeStr = typeStr.toLowerCase()).equals(IndexType.SORTED.name().toLowerCase())) {
            type = IndexType.SORTED;
        } else if (typeStr.equals(IndexType.HASH.name().toLowerCase())) {
            type = IndexType.HASH;
        } else {
            throw new IllegalArgumentException("Unsupported index type: " + typeStr);
        }
        IndexConfig res = new IndexConfig().setName(name).setType(type);
        Node attributesNode = attrs.getNamedItem("attributes");
        for (Node attributeNode : DomConfigHelper.childElements(attributesNode)) {
            String attribute = attributeNode.getNodeValue();
            res.addAttribute(attribute);
        }
        return res;
    }

    private static String getIndexTypeName(IndexType type) {
        switch (type) {
            case SORTED: {
                return "sorted";
            }
            case HASH: {
                return "hash";
            }
        }
        throw new IllegalArgumentException("Unsupported index type: " + (Object)((Object)type));
    }
}

