/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.PasswordCredentials;
import com.hazelcast.spi.impl.SpiPortableHook;
import java.io.IOException;
import java.util.Objects;

@BinaryInterface
public class UsernamePasswordCredentials
implements PasswordCredentials,
Portable {
    private static final long serialVersionUID = -1508314631354255039L;
    private String name;
    private String password;

    public UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String username, String password) {
        this.name = Objects.requireNonNull(username, "Username has to be provided.");
        this.password = Objects.requireNonNull(password, "Password has to be provided.");
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getFactoryId() {
        return SpiPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    public String toString() {
        return "UsernamePasswordCredentials{name=" + this.name + "}";
    }

    @Override
    public final void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
        writer.writeUTF("pwd", this.password);
        this.writePortableInternal(writer);
    }

    @Override
    public final void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
        this.password = reader.readUTF("pwd");
        this.readPortableInternal(reader);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsernamePasswordCredentials other = (UsernamePasswordCredentials)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.password == null ? other.password != null : !this.password.equals(other.password));
    }

    protected void writePortableInternal(PortableWriter writer) throws IOException {
    }

    protected void readPortableInternal(PortableReader reader) throws IOException {
    }
}

