/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.DelegatingCompletableFuture;
import com.hazelcast.spi.impl.DeserializingCompletableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class InternalCompletableFuture<V>
extends CompletableFuture<V> {
    public V joinInternal() {
        try {
            return (V)this.join();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            throw ExceptionUtil.sneakyThrow(AbstractInvocationFuture.wrapOrPeel(cause));
        }
    }

    public static <V> InternalCompletableFuture<V> newCompletedFuture(Object result) {
        InternalCompletableFuture<V> future = new InternalCompletableFuture<V>();
        future.complete(result);
        return future;
    }

    public static <V> InternalCompletableFuture<V> newCompletedFuture(Object result, @Nonnull SerializationService serializationService) {
        DeserializingCompletableFuture future = new DeserializingCompletableFuture(serializationService, true);
        future.complete(result);
        return future;
    }

    public static <V> InternalCompletableFuture<V> newCompletedFuture(Object result, @Nonnull Executor defaultAsyncExecutor) {
        DeserializingCompletableFuture future = new DeserializingCompletableFuture(defaultAsyncExecutor);
        future.complete(result);
        return future;
    }

    public static <V> InternalCompletableFuture<V> newCompletedFuture(Object result, @Nonnull SerializationService serializationService, @Nonnull Executor defaultAsyncExecutor) {
        DeserializingCompletableFuture future = new DeserializingCompletableFuture(serializationService, defaultAsyncExecutor, true);
        future.complete(result);
        return future;
    }

    public static <V> InternalCompletableFuture<V> completedExceptionally(@Nonnull Throwable t) {
        InternalCompletableFuture<V> future = new InternalCompletableFuture<V>();
        future.completeExceptionally(t);
        return future;
    }

    public static <V> InternalCompletableFuture<V> completedExceptionally(@Nonnull Throwable t, @Nonnull Executor defaultAsyncExecutor) {
        DeserializingCompletableFuture future = new DeserializingCompletableFuture(defaultAsyncExecutor);
        future.completeExceptionally(t);
        return future;
    }

    public static <V> InternalCompletableFuture<V> withExecutor(@Nonnull Executor defaultAsyncExecutor) {
        return new DeserializingCompletableFuture(defaultAsyncExecutor);
    }

    public static <V> InternalCompletableFuture<V> newDelegatingFuture(@Nonnull SerializationService serializationService, @Nonnull InternalCompletableFuture<Data> future) {
        return new DelegatingCompletableFuture(serializationService, future);
    }

    public static <U> BiConsumer<U, ? super Throwable> completingCallback(CompletableFuture<U> future) {
        return (u, throwable) -> {
            if (throwable == null) {
                future.complete(u);
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        };
    }
}

