/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.config.Config;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.dynamicconfig.DynamicConfigListener;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.FileMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.StatisticsAwareMetricsSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.PostJoinAwareService;
import com.hazelcast.internal.services.PreJoinAwareService;
import com.hazelcast.internal.usercodedeployment.UserCodeDeploymentClassLoader;
import com.hazelcast.internal.usercodedeployment.UserCodeDeploymentService;
import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.logging.impl.LoggingServiceImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.PacketDispatcher;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.executionservice.impl.ExecutionServiceImpl;
import com.hazelcast.spi.impl.operationparker.OperationParker;
import com.hazelcast.spi.impl.operationparker.impl.OperationParkerImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import com.hazelcast.spi.impl.servicemanager.ServiceManager;
import com.hazelcast.spi.impl.servicemanager.impl.ServiceManagerImpl;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.splitbrainprotection.impl.SplitBrainProtectionServiceImpl;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.wan.impl.WanReplicationService;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class NodeEngineImpl
implements NodeEngine {
    private final Node node;
    private final SerializationService serializationService;
    private final LoggingServiceImpl loggingService;
    private final ILogger logger;
    private final MetricsRegistryImpl metricsRegistry;
    private final ProxyServiceImpl proxyService;
    private final ServiceManagerImpl serviceManager;
    private final ExecutionServiceImpl executionService;
    private final OperationServiceImpl operationService;
    private final EventServiceImpl eventService;
    private final OperationParkerImpl operationParker;
    private final ClusterWideConfigurationService configurationService;
    private final TransactionManagerServiceImpl transactionManagerService;
    private final WanReplicationService wanReplicationService;
    private final Consumer<Packet> packetDispatcher;
    private final SplitBrainProtectionServiceImpl splitBrainProtectionService;
    private final Diagnostics diagnostics;
    private final SplitBrainMergePolicyProvider splitBrainMergePolicyProvider;
    private final ConcurrencyDetection concurrencyDetection;

    public NodeEngineImpl(Node node) {
        this.node = node;
        try {
            this.serializationService = node.getSerializationService();
            this.concurrencyDetection = this.newConcurrencyDetection();
            this.loggingService = node.loggingService;
            this.logger = node.getLogger(NodeEngine.class.getName());
            this.metricsRegistry = this.newMetricRegistry(node);
            this.proxyService = new ProxyServiceImpl(this);
            this.serviceManager = new ServiceManagerImpl(this);
            this.executionService = new ExecutionServiceImpl(this);
            this.operationService = new OperationServiceImpl(this);
            this.eventService = new EventServiceImpl(this);
            this.operationParker = new OperationParkerImpl(this);
            UserCodeDeploymentService userCodeDeploymentService = new UserCodeDeploymentService();
            DynamicConfigListener dynamicConfigListener = node.getNodeExtension().createDynamicConfigListener();
            this.configurationService = new ClusterWideConfigurationService(this, dynamicConfigListener);
            ClassLoader configClassLoader = node.getConfigClassLoader();
            if (configClassLoader instanceof UserCodeDeploymentClassLoader) {
                ((UserCodeDeploymentClassLoader)configClassLoader).setUserCodeDeploymentService(userCodeDeploymentService);
            }
            this.transactionManagerService = new TransactionManagerServiceImpl(this);
            this.wanReplicationService = node.getNodeExtension().createService(WanReplicationService.class);
            this.packetDispatcher = new PacketDispatcher(this.logger, this.operationService.getOperationExecutor(), (Consumer<Packet>)this.operationService.getInboundResponseHandlerSupplier().get(), this.operationService.getInvocationMonitor(), this.eventService, this.getJetPacketConsumer(node.getNodeExtension()));
            this.splitBrainProtectionService = new SplitBrainProtectionServiceImpl(this);
            this.diagnostics = this.newDiagnostics();
            this.splitBrainMergePolicyProvider = new SplitBrainMergePolicyProvider(this);
            this.serviceManager.registerService("hz:impl:operationService", this.operationService);
            this.serviceManager.registerService("hz:impl:operationParker", this.operationParker);
            this.serviceManager.registerService("user-code-deployment-service", userCodeDeploymentService);
            this.serviceManager.registerService("configuration-service", this.configurationService);
        }
        catch (Throwable e) {
            try {
                this.shutdown(true);
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private ConcurrencyDetection newConcurrencyDetection() {
        HazelcastProperties properties = this.node.getProperties();
        boolean writeThrough = properties.getBoolean(GroupProperty.IO_WRITE_THROUGH_ENABLED);
        boolean backPressureEnabled = properties.getBoolean(GroupProperty.BACKPRESSURE_ENABLED);
        if (writeThrough || backPressureEnabled) {
            return ConcurrencyDetection.createEnabled(properties.getInteger(GroupProperty.CONCURRENT_WINDOW_MS));
        }
        return ConcurrencyDetection.createDisabled();
    }

    private MetricsRegistryImpl newMetricRegistry(Node node) {
        ProbeLevel minimumLevel = node.getConfig().getMetricsConfig().getMinimumLevel();
        return new MetricsRegistryImpl(this.getHazelcastInstance().getName(), node.getLogger(MetricsRegistry.class), minimumLevel);
    }

    private Diagnostics newDiagnostics() {
        Address address = this.node.getThisAddress();
        String addressString = address.getHost().replace(":", "_") + "_" + address.getPort();
        String name = "diagnostics-" + addressString + "-" + System.currentTimeMillis();
        return new Diagnostics(name, this.loggingService.getLogger(Diagnostics.class), this.getHazelcastInstance().getName(), this.node.getProperties());
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void start() {
        RuntimeMetricSet.register(this.metricsRegistry);
        GarbageCollectionMetricSet.register(this.metricsRegistry);
        OperatingSystemMetricSet.register(this.metricsRegistry);
        ThreadMetricSet.register(this.metricsRegistry);
        ClassLoadingMetricSet.register(this.metricsRegistry);
        FileMetricSet.register(this.metricsRegistry);
        MetricsConfig metricsConfig = this.node.getConfig().getMetricsConfig();
        if (metricsConfig.isEnabled() && metricsConfig.isMetricsForDataStructuresEnabled()) {
            StatisticsAwareMetricsSet.register(this.serviceManager, this.metricsRegistry);
        }
        this.metricsRegistry.registerStaticMetrics(this.node.getNodeExtension().getMemoryStats(), "memory");
        this.metricsRegistry.provideMetrics(this.operationService, this.proxyService, this.eventService, this.operationParker);
        this.serviceManager.start();
        this.proxyService.init();
        this.operationService.start();
        this.splitBrainProtectionService.start();
        this.diagnostics.start();
        this.node.getNodeExtension().registerPlugins(this.diagnostics);
    }

    public ConcurrencyDetection getConcurrencyDetection() {
        return this.concurrencyDetection;
    }

    public Consumer<Packet> getPacketDispatcher() {
        return this.packetDispatcher;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public ClusterWideConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ClassLoader getConfigClassLoader() {
        return this.node.getConfigClassLoader();
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public OperationServiceImpl getOperationService() {
        return this.operationService;
    }

    @Override
    public ExecutionService getExecutionService() {
        return this.executionService;
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.node.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.node.getClusterService();
    }

    public ManagementCenterService getManagementCenterService() {
        return this.node.getManagementCenterService();
    }

    @Override
    public InternalProxyService getProxyService() {
        return this.proxyService;
    }

    public OperationParker getOperationParker() {
        return this.operationParker;
    }

    @Override
    public WanReplicationService getWanReplicationService() {
        return this.wanReplicationService;
    }

    @Override
    public SplitBrainProtectionServiceImpl getSplitBrainProtectionService() {
        return this.splitBrainProtectionService;
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.transactionManagerService;
    }

    @Override
    public Data toData(Object object) {
        return this.serializationService.toData(object);
    }

    @Override
    public <T> T toObject(Object object) {
        return this.serializationService.toObject(object);
    }

    @Override
    public <T> T toObject(Object object, Class klazz) {
        return this.serializationService.toObject(object, klazz);
    }

    @Override
    public boolean isActive() {
        return this.isRunning();
    }

    @Override
    public boolean isRunning() {
        return this.node.isRunning();
    }

    @Override
    public HazelcastInstance getHazelcastInstance() {
        return this.node.hazelcastInstance;
    }

    @Override
    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.loggingService.getLogger(clazz);
    }

    @Override
    public HazelcastProperties getProperties() {
        return this.node.getProperties();
    }

    @Override
    public <T> T getService(String serviceName) {
        Object service = this.serviceManager.getService(serviceName);
        if (service == null) {
            if (this.isRunning()) {
                throw new HazelcastException("Service with name '" + serviceName + "' not found!", new ServiceNotFoundException("Service with name '" + serviceName + "' not found!"));
            }
            throw new RetryableHazelcastException("HazelcastInstance[" + this.getThisAddress() + "] is not active!");
        }
        return service;
    }

    @Override
    public <T> T getServiceOrNull(String serviceName) {
        return this.serviceManager.getService(serviceName);
    }

    @Override
    public MemberVersion getVersion() {
        return this.node.getVersion();
    }

    @Override
    public SplitBrainMergePolicyProvider getSplitBrainMergePolicyProvider() {
        return this.splitBrainMergePolicyProvider;
    }

    @Override
    public <S> Collection<S> getServices(Class<S> serviceClass) {
        return this.serviceManager.getServices(serviceClass);
    }

    public Collection<ServiceInfo> getServiceInfos(Class serviceClass) {
        return this.serviceManager.getServiceInfos(serviceClass);
    }

    public Node getNode() {
        return this.node;
    }

    public void onMemberLeft(MemberImpl member) {
        this.operationParker.onMemberLeft(member);
        this.operationService.onMemberLeft(member);
        this.eventService.onMemberLeft(member);
    }

    public void onClientDisconnected(UUID clientUuid) {
        this.operationParker.onClientDisconnected(clientUuid);
    }

    public void onPartitionMigrate(MigrationInfo migrationInfo) {
        this.operationParker.onPartitionMigrate(migrationInfo);
    }

    public Collection<Operation> getPostJoinOperations() {
        LinkedList<Operation> postJoinOps = new LinkedList<Operation>();
        Collection<PostJoinAwareService> services = this.getServices(PostJoinAwareService.class);
        for (PostJoinAwareService service : services) {
            Operation postJoinOperation = service.getPostJoinOperation();
            if (postJoinOperation == null) continue;
            if (postJoinOperation.getPartitionId() >= 0) {
                this.logger.severe("Post-join operations should not have partition ID set! Service: " + service + ", Operation: " + postJoinOperation);
                continue;
            }
            postJoinOps.add(postJoinOperation);
        }
        return postJoinOps;
    }

    public Collection<Operation> getPreJoinOperations() {
        LinkedList<Operation> preJoinOps = new LinkedList<Operation>();
        Collection<PreJoinAwareService> services = this.getServices(PreJoinAwareService.class);
        for (PreJoinAwareService service : services) {
            Operation preJoinOperation = service.getPreJoinOperation();
            if (preJoinOperation == null) continue;
            if (preJoinOperation.getPartitionId() >= 0) {
                this.logger.severe("Pre-join operations operations should not have partition ID set! Service: " + service + ", Operation: " + preJoinOperation);
                continue;
            }
            preJoinOps.add(preJoinOperation);
        }
        return preJoinOps;
    }

    public void reset() {
        this.operationParker.reset();
        this.operationService.reset();
    }

    public void shutdown(boolean terminate) {
        this.logger.finest("Shutting down services...");
        if (this.operationParker != null) {
            this.operationParker.shutdown();
        }
        if (this.operationService != null) {
            this.operationService.shutdownInvocations();
        }
        if (this.proxyService != null) {
            this.proxyService.shutdown();
        }
        if (this.serviceManager != null) {
            this.serviceManager.shutdown(terminate);
        }
        if (this.eventService != null) {
            this.eventService.shutdown();
        }
        if (this.operationService != null) {
            this.operationService.shutdownOperationExecutor();
        }
        if (this.wanReplicationService != null) {
            this.wanReplicationService.shutdown();
        }
        if (this.executionService != null) {
            this.executionService.shutdown();
        }
        if (this.metricsRegistry != null) {
            this.metricsRegistry.shutdown();
        }
        if (this.diagnostics != null) {
            this.diagnostics.shutdown();
        }
    }

    @Nonnull
    private Consumer<Packet> getJetPacketConsumer(NodeExtension nodeExtension) {
        if (nodeExtension instanceof JetPacketConsumer) {
            return (JetPacketConsumer)((Object)nodeExtension);
        }
        return new JetPacketConsumer(){

            @Override
            public void accept(Packet packet) {
                throw new UnsupportedOperationException("Jet is not registered on this node");
            }
        };
    }

    public static interface JetPacketConsumer
    extends Consumer<Packet> {
    }
}

