/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.impl.SpiPortableHook;
import java.io.IOException;
import java.util.UUID;

public class PortableCachePartitionLostEvent
implements Portable {
    private int partitionId;
    private UUID uuid;

    public PortableCachePartitionLostEvent() {
    }

    public PortableCachePartitionLostEvent(int partitionId, UUID uuid) {
        this.partitionId = partitionId;
        this.uuid = uuid;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getFactoryId() {
        return SpiPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("p", this.partitionId);
        writer.writeLong("uHigh", this.uuid.getMostSignificantBits());
        writer.writeLong("uLow", this.uuid.getLeastSignificantBits());
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.partitionId = reader.readInt("p");
        this.uuid = new UUID(reader.readLong("uHigh"), reader.readLong("uLow"));
    }
}

