/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.impl.SpiPortableHook;
import java.io.IOException;
import java.util.UUID;

public class PortableItemEvent
implements Portable {
    private Data item;
    private ItemEventType eventType;
    private UUID uuid;

    public PortableItemEvent() {
    }

    public PortableItemEvent(Data item, ItemEventType eventType, UUID uuid) {
        this.item = item;
        this.eventType = eventType;
        this.uuid = uuid;
    }

    public Data getItem() {
        return this.item;
    }

    public ItemEventType getEventType() {
        return this.eventType;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getFactoryId() {
        return SpiPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("e", this.eventType.getType());
        writer.writeLong("uHigh", this.uuid.getMostSignificantBits());
        writer.writeLong("uLow", this.uuid.getLeastSignificantBits());
        writer.getRawDataOutput().writeData(this.item);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.eventType = ItemEventType.getByType(reader.readInt("e"));
        this.uuid = new UUID(reader.readLong("uHigh"), reader.readLong("uLow"));
        this.item = reader.getRawDataInput().readData();
    }
}

