/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionLogRecord;
import java.util.UUID;

class TransactionWrapper
implements Transaction {
    private Transaction transaction;

    TransactionWrapper(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void begin() throws IllegalStateException {
        this.transaction.begin();
    }

    @Override
    public void prepare() throws TransactionException {
        this.transaction.prepare();
    }

    @Override
    public void commit() throws TransactionException, IllegalStateException {
        this.transaction.commit();
    }

    @Override
    public void rollback() throws IllegalStateException {
        this.transaction.rollback();
    }

    @Override
    public UUID getTxnId() {
        return this.transaction.getTxnId();
    }

    @Override
    public Transaction.State getState() {
        return this.transaction.getState();
    }

    @Override
    public long getTimeoutMillis() {
        return this.transaction.getTimeoutMillis();
    }

    @Override
    public void add(TransactionLogRecord record) {
        this.transaction.add(record);
    }

    @Override
    public void remove(Object key) {
        this.transaction.remove(key);
    }

    @Override
    public TransactionLogRecord get(Object key) {
        return this.transaction.get(key);
    }

    @Override
    public UUID getOwnerUuid() {
        return this.transaction.getOwnerUuid();
    }

    @Override
    public boolean isOriginatedFromClient() {
        return this.transaction.isOriginatedFromClient();
    }

    @Override
    public TransactionOptions.TransactionType getTransactionType() {
        return this.transaction.getTransactionType();
    }

    void set(Transaction transaction) {
        this.transaction = transaction;
    }

    <T extends Transaction> T getTransactionOfRequiredType(Class<T> type) {
        if (this.transaction == null || !type.isAssignableFrom(this.transaction.getClass())) {
            throw new IllegalStateException("Invalid transaction state.");
        }
        return (T)((Transaction)type.cast(this.transaction));
    }
}

