/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.config.AbstractWanPublisherConfig;
import com.hazelcast.config.CustomWanPublisherConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.WanBatchReplicationPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.events.AddWanConfigIgnoredEvent;
import com.hazelcast.internal.management.events.WanConsistencyCheckIgnoredEvent;
import com.hazelcast.internal.management.events.WanSyncIgnoredEvent;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.monitor.LocalWanStats;
import com.hazelcast.monitor.WanSyncState;
import com.hazelcast.version.Version;
import com.hazelcast.wan.DistributedServiceWanEventCounters;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.wan.impl.DelegatingWanReplicationScheme;
import com.hazelcast.wan.impl.WanEventCounters;
import com.hazelcast.wan.impl.WanReplicationService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class WanReplicationServiceImpl
implements WanReplicationService {
    private final Node node;
    private final WanEventCounters receivedWanEventCounters = new WanEventCounters();
    private final WanEventCounters sentWanEventCounters = new WanEventCounters();
    private final ConcurrentMap<String, DelegatingWanReplicationScheme> wanReplications = MapUtil.createConcurrentHashMap(1);
    private final ConstructorFunction<String, DelegatingWanReplicationScheme> publisherDelegateConstructorFunction = new ConstructorFunction<String, DelegatingWanReplicationScheme>(){

        @Override
        public DelegatingWanReplicationScheme createNew(String name) {
            WanReplicationConfig wanReplicationConfig = WanReplicationServiceImpl.this.node.getConfig().getWanReplicationConfig(name);
            if (wanReplicationConfig == null) {
                return null;
            }
            List<WanBatchReplicationPublisherConfig> batchPublisherConfigs = wanReplicationConfig.getBatchPublisherConfigs();
            if (!batchPublisherConfigs.isEmpty()) {
                throw new InvalidConfigurationException("Built-in batching WAN replication implementation is only available in Hazelcast enterprise edition.");
            }
            return new DelegatingWanReplicationScheme(name, WanReplicationServiceImpl.this.createPublishers(wanReplicationConfig));
        }
    };

    public WanReplicationServiceImpl(Node node) {
        this.node = node;
    }

    @Override
    public DelegatingWanReplicationScheme getWanReplicationPublishers(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.wanReplications, name, this, this.publisherDelegateConstructorFunction);
    }

    private ConcurrentMap<String, WanReplicationPublisher> createPublishers(WanReplicationConfig wanConfig) {
        List<CustomWanPublisherConfig> customPublisherConfigs = wanConfig.getCustomPublisherConfigs();
        int publisherCount = customPublisherConfigs.size();
        if (publisherCount == 0) {
            return MapUtil.createConcurrentHashMap(1);
        }
        ConcurrentMap<String, WanReplicationPublisher> publishers = MapUtil.createConcurrentHashMap(publisherCount);
        Map publisherConfigs = MapUtil.createHashMap(publisherCount);
        customPublisherConfigs.forEach(publisherConfig -> {
            String publisherId = WanReplicationServiceImpl.getWanPublisherId(publisherConfig);
            if (publishers.containsKey(publisherId)) {
                throw new InvalidConfigurationException("Detected duplicate publisher ID '" + publisherId + "' for a single WAN replication config");
            }
            WanReplicationPublisher publisher = this.createPublisher((AbstractWanPublisherConfig)publisherConfig);
            publishers.put(publisherId, publisher);
            publisherConfigs.put(publisherId, publisherConfig);
        });
        for (Map.Entry publisherEntry : publishers.entrySet()) {
            String publisherId = (String)publisherEntry.getKey();
            WanReplicationPublisher publisher = (WanReplicationPublisher)publisherEntry.getValue();
            this.node.getSerializationService().getManagedContext().initialize(publisher);
            publisher.init(wanConfig, (AbstractWanPublisherConfig)publisherConfigs.get(publisherId));
        }
        return publishers;
    }

    private WanReplicationPublisher createPublisher(AbstractWanPublisherConfig publisherConfig) {
        WanReplicationPublisher publisher = ClassLoaderUtil.getOrCreate((WanReplicationPublisher)publisherConfig.getImplementation(), this.node.getConfigClassLoader(), publisherConfig.getClassName());
        if (publisher == null) {
            throw new InvalidConfigurationException("Either 'implementation' or 'className' attribute need to be set in the WAN publisher configuration for publisher " + publisherConfig);
        }
        return publisher;
    }

    @Nonnull
    public static String getWanPublisherId(AbstractWanPublisherConfig publisherConfig) {
        String publisherId = null;
        if (!StringUtil.isNullOrEmptyAfterTrim(publisherConfig.getPublisherId())) {
            publisherId = publisherConfig.getPublisherId();
        } else if (publisherConfig instanceof WanBatchReplicationPublisherConfig) {
            publisherId = ((WanBatchReplicationPublisherConfig)publisherConfig).getClusterName();
        }
        if (publisherId == null) {
            throw new InvalidConfigurationException("Publisher ID or group name is not specified for " + publisherConfig);
        }
        return publisherId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        WanReplicationServiceImpl wanReplicationServiceImpl = this;
        synchronized (wanReplicationServiceImpl) {
            for (DelegatingWanReplicationScheme delegate : this.wanReplications.values()) {
                for (WanReplicationPublisher publisher : delegate.getPublishers()) {
                    if (publisher == null) continue;
                    publisher.shutdown();
                }
            }
            this.wanReplications.clear();
        }
    }

    @Override
    public void pause(String wanReplicationName, String wanPublisherId) {
        throw new UnsupportedOperationException("Pausing WAN replication is not supported.");
    }

    @Override
    public void stop(String wanReplicationName, String wanPublisherId) {
        throw new UnsupportedOperationException("Stopping WAN replication is not supported");
    }

    @Override
    public void resume(String wanReplicationName, String wanPublisherId) {
        throw new UnsupportedOperationException("Resuming WAN replication is not supported");
    }

    @Override
    public UUID syncMap(String wanReplicationName, String wanPublisherId, String mapName) {
        this.node.getManagementCenterService().log(WanSyncIgnoredEvent.enterpriseOnly(wanReplicationName, wanPublisherId, mapName));
        throw new UnsupportedOperationException("WAN sync for map is not supported.");
    }

    @Override
    public UUID syncAllMaps(String wanReplicationName, String wanPublisherId) {
        this.node.getManagementCenterService().log(WanSyncIgnoredEvent.enterpriseOnly(wanReplicationName, wanPublisherId, null));
        throw new UnsupportedOperationException("WAN sync is not supported.");
    }

    @Override
    public UUID consistencyCheck(String wanReplicationName, String wanPublisherId, String mapName) {
        this.node.getManagementCenterService().log(new WanConsistencyCheckIgnoredEvent(wanReplicationName, wanPublisherId, mapName, "Consistency check is supported for enterprise clusters only."));
        throw new UnsupportedOperationException("Consistency check is not supported.");
    }

    @Override
    public void removeWanEvents(String wanReplicationName, String wanPublisherId) {
        throw new UnsupportedOperationException("Clearing WAN replication queues is not supported.");
    }

    @Override
    public AddWanConfigResult addWanReplicationConfig(WanReplicationConfig wanConfig) {
        this.node.getManagementCenterService().log(AddWanConfigIgnoredEvent.enterpriseOnly(wanConfig.getName()));
        throw new UnsupportedOperationException("Adding new WAN config is not supported.");
    }

    @Override
    public void addWanReplicationConfigLocally(WanReplicationConfig wanConfig) {
        throw new UnsupportedOperationException("Adding new WAN config is not supported.");
    }

    @Override
    public Map<String, LocalWanStats> getStats() {
        return null;
    }

    @Override
    public WanSyncState getWanSyncState() {
        return null;
    }

    @Override
    public DistributedServiceWanEventCounters getReceivedEventCounters(String serviceName) {
        return this.receivedWanEventCounters.getWanEventCounter("", "", serviceName);
    }

    @Override
    public DistributedServiceWanEventCounters getSentEventCounters(String wanReplicationName, String wanPublisherId, String serviceName) {
        return this.sentWanEventCounters.getWanEventCounter(wanReplicationName, wanPublisherId, serviceName);
    }

    @Override
    public void removeWanEventCounters(String serviceName, String objectName) {
        this.receivedWanEventCounters.removeCounter(serviceName, objectName);
        this.sentWanEventCounters.removeCounter(serviceName, objectName);
    }

    @Override
    public List<Version> getSupportedWanProtocolVersions() {
        return Collections.emptyList();
    }
}

