/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheCreateConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheManagementConfigCodec;
import com.hazelcast.client.impl.protocol.codec.holder.CacheConfigHolder;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

final class ClientCacheHelper {
    private ClientCacheHelper() {
    }

    static <K, V> CacheConfig<K, V> getCacheConfig(HazelcastClientInstanceImpl client, String cacheName, String simpleCacheName) {
        ClientMessage request = CacheGetConfigCodec.encodeRequest(cacheName, simpleCacheName);
        try {
            int partitionId = client.getClientPartitionService().getPartitionId(cacheName);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, (Object)cacheName, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            ClientMessage responseMessage = (ClientMessage)future.get();
            InternalSerializationService serializationService = client.getSerializationService();
            CacheConfigHolder cacheConfigHolder = CacheGetConfigCodec.decodeResponse((ClientMessage)responseMessage).response;
            if (cacheConfigHolder == null) {
                return null;
            }
            return cacheConfigHolder.asCacheConfig(serializationService);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    static <K, V> CacheConfig<K, V> createCacheConfig(HazelcastClientInstanceImpl client, CacheConfig<K, V> newCacheConfig, boolean urgent) {
        try {
            String nameWithPrefix = newCacheConfig.getNameWithPrefix();
            int partitionId = client.getClientPartitionService().getPartitionId(nameWithPrefix);
            InternalSerializationService serializationService = client.getSerializationService();
            ClientMessage request = CacheCreateConfigCodec.encodeRequest(CacheConfigHolder.of(newCacheConfig, serializationService), true);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, (Object)nameWithPrefix, partitionId);
            ClientInvocationFuture future = urgent ? clientInvocation.invokeUrgent() : clientInvocation.invoke();
            ClientMessage response = (ClientMessage)future.get();
            CacheConfigHolder cacheConfigHolder = CacheCreateConfigCodec.decodeResponse((ClientMessage)response).response;
            if (cacheConfigHolder == null) {
                return null;
            }
            return cacheConfigHolder.asCacheConfig(serializationService);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    static void enableStatisticManagementOnNodes(HazelcastClientInstanceImpl client, String cacheName, boolean statOrMan, boolean enabled) {
        Collection<Member> members = client.getClientClusterService().getMemberList();
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>();
        for (Member member : members) {
            try {
                Address address = member.getAddress();
                ClientMessage request = CacheManagementConfigCodec.encodeRequest(cacheName, statOrMan, enabled, address);
                ClientInvocation clientInvocation = new ClientInvocation(client, request, (Object)cacheName, address);
                ClientInvocationFuture future = clientInvocation.invoke();
                futures.add(future);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
        FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
    }
}

