/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.HazelcastCacheManager;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.cache.impl.CacheStatsHandler;
import com.hazelcast.client.cache.impl.ClientCacheProxySupportUtil;
import com.hazelcast.client.cache.impl.ClientCacheProxySyncListenerCompleter;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheClearCodec;
import com.hazelcast.client.impl.protocol.codec.CacheContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.CacheEntryProcessorCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetCodec;
import com.hazelcast.client.impl.protocol.codec.CacheListenerRegistrationCodec;
import com.hazelcast.client.impl.protocol.codec.CacheLoadAllCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutAllCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.CacheSetExpiryPolicyCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.io.Closeable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessorException;

abstract class ClientCacheProxySupport<K, V>
extends ClientProxy
implements ICacheInternal<K, V>,
CacheSyncListenerCompleter {
    private static final int TIMEOUT = 10;
    private static final CompletionListener NULL_COMPLETION_LISTENER = new ClientCacheProxySupportUtil.EmptyCompletionListener();
    protected final String name;
    protected final String nameWithPrefix;
    protected final CacheConfig<K, V> cacheConfig;
    protected int partitionCount;
    boolean statisticsEnabled;
    CacheStatsHandler statsHandler;
    private ILogger logger;
    private final AtomicReference<HazelcastClientCacheManager> cacheManagerRef = new AtomicReference();
    private final ConcurrentMap<Future, CompletionListener> loadAllCalls = new ConcurrentHashMap<Future, CompletionListener>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicInteger completionIdCounter = new AtomicInteger();
    private final ClientCacheProxySyncListenerCompleter listenerCompleter;
    private final ConcurrentMap<UUID, Closeable> closeableListeners;

    protected ClientCacheProxySupport(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super("hz:impl:cacheService", cacheConfig.getName(), context);
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
        this.statisticsEnabled = cacheConfig.isStatisticsEnabled();
        this.closeableListeners = new ConcurrentHashMap<UUID, Closeable>();
        this.listenerCompleter = new ClientCacheProxySyncListenerCompleter(this);
    }

    @Override
    protected void onInitialize() {
        this.logger = this.getContext().getLoggingService().getLogger(this.getClass());
        this.statsHandler = new CacheStatsHandler(this.getSerializationService());
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        this.partitionCount = partitionService.getPartitionCount();
    }

    @Override
    protected String getDistributedObjectName() {
        return this.cacheConfig.getNameWithPrefix();
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        if (this.statisticsEnabled) {
            this.statsHandler.clear();
        }
        this.close0(false);
    }

    @Override
    protected boolean preDestroy() {
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return false;
        }
        this.close0(true);
        this.isClosed.set(true);
        return true;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    @Override
    public void open() {
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("Cache is already destroyed! Cannot be reopened");
        }
        this.isClosed.set(false);
    }

    @Override
    public String getPrefixedName() {
        return this.nameWithPrefix;
    }

    @Override
    protected <T> T invoke(ClientMessage clientMessage) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, this.getName()).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void countDownCompletionLatch(int countDownLatchId) {
        this.listenerCompleter.countDownCompletionLatch(countDownLatchId);
    }

    public CacheManager getCacheManager() {
        return this.cacheManagerRef.get();
    }

    @Override
    public void setCacheManager(HazelcastCacheManager cacheManager) {
        assert (cacheManager instanceof HazelcastClientCacheManager);
        if (this.cacheManagerRef.get() == cacheManager) {
            return;
        }
        if (!this.cacheManagerRef.compareAndSet(null, (HazelcastClientCacheManager)cacheManager)) {
            throw new IllegalStateException("Cannot overwrite a Cache's CacheManager.");
        }
    }

    @Override
    public void resetCacheManager() {
        this.cacheManagerRef.set(null);
    }

    @Override
    protected void postDestroy() {
        CacheManager cacheManager = this.cacheManagerRef.get();
        if (cacheManager != null) {
            cacheManager.destroyCache(this.getName());
        }
        this.resetCacheManager();
    }

    @Override
    protected void onDestroy() {
        if (this.statisticsEnabled) {
            this.statsHandler.clear();
        }
        super.onDestroy();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    protected void injectDependencies(Object obj) {
        ManagedContext managedContext = this.getSerializationService().getManagedContext();
        managedContext.initialize(obj);
    }

    protected void onLoadAll(List<Data> keys, Object response, long startNanos) {
    }

    protected long nowInNanosOrDefault() {
        return this.statisticsEnabled ? System.nanoTime() : -1L;
    }

    protected ClientInvocationFuture invoke(ClientMessage req, int partitionId, int completionId) {
        boolean completionOperation;
        boolean bl = completionOperation = completionId != -1;
        if (completionOperation) {
            this.listenerCompleter.registerCompletionLatch(completionId, 1);
        }
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), req, (Object)this.name, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            if (completionOperation) {
                this.listenerCompleter.waitCompletionLatch((Integer)completionId, future);
            }
            return future;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.listenerCompleter.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    protected ClientInvocationFuture invoke(ClientMessage req, Data keyData, int completionId) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        return this.invoke(req, partitionId, completionId);
    }

    protected <T> InternalCompletableFuture<T> getAndRemoveAsyncInternal(K key) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        Data keyData = this.toData(key);
        ClientDelegatingFuture<T> delegatingFuture = this.getAndRemoveInternal(keyData, false);
        BiConsumer callback = !this.statisticsEnabled ? null : this.statsHandler.newOnRemoveCallback(true, startNanos);
        this.onGetAndRemoveAsyncInternal(key, keyData, delegatingFuture, callback);
        return delegatingFuture;
    }

    protected <T> ClientDelegatingFuture<T> getAndRemoveSyncInternal(K key) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        Data keyData = this.toData(key);
        ClientDelegatingFuture<T> delegatingFuture = this.getAndRemoveInternal(keyData, true);
        this.onGetAndRemoveAsyncInternal(key, keyData, delegatingFuture, null);
        return delegatingFuture;
    }

    protected <T> void onGetAndRemoveAsyncInternal(K key, Data keyData, ClientDelegatingFuture<T> delegatingFuture, BiConsumer<T, Throwable> callback) {
        ClientCacheProxySupportUtil.addCallback(delegatingFuture, callback);
    }

    protected Object removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheRemoveCodec.encodeRequest(this.nameWithPrefix, keyData, oldValueData, completionId);
        ClientInvocationFuture future = this.invoke(request, keyData, completionId);
        ClientDelegatingFuture delegatingFuture = this.newDelegatingFuture(future, clientMessage -> CacheRemoveCodec.decodeResponse((ClientMessage)clientMessage).response);
        if (async) {
            BiConsumer<Object, Throwable> callback = !this.statisticsEnabled ? null : this.statsHandler.newOnRemoveCallback(false, startNanos);
            this.onRemoveAsyncInternal(key, keyData, delegatingFuture, callback);
            return delegatingFuture;
        }
        try {
            Object result = delegatingFuture.get();
            this.onRemoveSyncInternal(key, keyData);
            return result;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected void onRemoveSyncInternal(Object key, Data keyData) {
    }

    protected void onRemoveAsyncInternal(Object key, Data keyData, ClientDelegatingFuture future, BiConsumer<Object, Throwable> callback) {
        ClientCacheProxySupportUtil.addCallback(future, callback);
    }

    protected boolean replaceSyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue) {
        long startNanos = this.nowInNanosOrDefault();
        InternalCompletableFuture future = this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, hasOldValue, true, false);
        try {
            boolean replaced = (Boolean)future.get();
            if (this.statisticsEnabled) {
                this.statsHandler.onReplace(false, startNanos, replaced);
            }
            return replaced;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    protected <T> InternalCompletableFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheReplaceCodec.encodeRequest(this.nameWithPrefix, keyData, oldValueData, newValueData, expiryPolicyData, completionId);
        ClientInvocationFuture future = this.invoke(request, keyData, completionId);
        ClientDelegatingFuture<T> delegatingFuture = this.newDelegatingFuture(future, message -> CacheReplaceCodec.decodeResponse((ClientMessage)message).response);
        BiConsumer callback = async && this.statisticsEnabled ? this.statsHandler.newOnReplaceCallback(startNanos) : null;
        this.onReplaceInternalAsync(key, newValue, keyData, newValueData, delegatingFuture, callback);
        return delegatingFuture;
    }

    protected <T> void onReplaceInternalAsync(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<T> delegatingFuture, BiConsumer<T, Throwable> callback) {
        ClientCacheProxySupportUtil.addCallback(delegatingFuture, callback);
    }

    protected <T> InternalCompletableFuture<T> replaceAndGetAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndReplaceCodec.encodeRequest(this.nameWithPrefix, keyData, newValueData, expiryPolicyData, completionId);
        ClientInvocationFuture future = this.invoke(request, keyData, completionId);
        ClientDelegatingFuture<T> delegatingFuture = this.newDelegatingFuture(future, message -> CacheGetAndReplaceCodec.decodeResponse((ClientMessage)message).response);
        BiConsumer callback = async && this.statisticsEnabled ? this.statsHandler.newOnReplaceCallback(startNanos) : null;
        this.onReplaceAndGetAsync(key, newValue, keyData, newValueData, delegatingFuture, callback);
        return delegatingFuture;
    }

    protected <T> void onReplaceAndGetAsync(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<T> delegatingFuture, BiConsumer<T, Throwable> callback) {
        ClientCacheProxySupportUtil.addCallback(delegatingFuture, callback);
    }

    protected V putSyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        try {
            ClientInvocationFuture invocationFuture = this.putInternal(keyData, valueData, expiryPolicyData, isGet, true);
            ClientDelegatingFuture delegatingFuture = this.newDelegatingFuture(invocationFuture, clientMessage -> CachePutCodec.decodeResponse((ClientMessage)clientMessage).response);
            Object response = delegatingFuture.get();
            if (this.statisticsEnabled) {
                this.statsHandler.onPut(isGet, startNanos, response != null);
            }
            Object v = response;
            return v;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
        finally {
            this.onPutSyncInternal(key, value, keyData, valueData);
        }
    }

    protected void onPutSyncInternal(K key, V value, Data keyData, Data valueData) {
    }

    protected ClientDelegatingFuture putAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent, BiConsumer<V, Throwable> callback) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        ClientInvocationFuture invocationFuture = this.putInternal(keyData, valueData, expiryPolicyData, isGet, withCompletionEvent);
        return this.wrapPutAsyncFuture(key, value, keyData, valueData, invocationFuture, callback);
    }

    protected ClientDelegatingFuture<V> wrapPutAsyncFuture(K key, V value, Data keyData, Data valueData, ClientInvocationFuture invocationFuture, BiConsumer<V, Throwable> callback) {
        ClientDelegatingFuture future = this.newDelegatingFuture(invocationFuture, message -> CachePutCodec.decodeResponse((ClientMessage)message).response);
        if (callback != null) {
            future.whenComplete(callback);
        }
        return future;
    }

    protected BiConsumer<V, Throwable> newStatsCallbackOrNull(boolean isGet) {
        if (!this.statisticsEnabled) {
            return null;
        }
        return this.statsHandler.newOnPutCallback(isGet, System.nanoTime());
    }

    protected boolean setExpiryPolicyInternal(K key, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        CacheProxyUtil.validateNotNull(expiryPolicy);
        Data keyData = this.toData(key);
        Data expiryPolicyData = this.toData(expiryPolicy);
        List<Data> list = Collections.singletonList(keyData);
        ClientMessage request = CacheSetExpiryPolicyCodec.encodeRequest(this.nameWithPrefix, list, expiryPolicyData);
        ClientInvocationFuture future = this.invoke(request, keyData, -1);
        ClientDelegatingFuture delegatingFuture = this.newDelegatingFuture(future, clientMessage -> CacheSetExpiryPolicyCodec.decodeResponse((ClientMessage)clientMessage).response);
        try {
            return (Boolean)delegatingFuture.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    protected Object putIfAbsentInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent, boolean async) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutIfAbsentCodec.encodeRequest(this.nameWithPrefix, keyData, valueData, expiryPolicyData, completionId);
        ClientInvocationFuture future = this.invoke(request, keyData, completionId);
        ClientDelegatingFuture<Boolean> delegatingFuture = this.newDelegatingFuture(future, message -> CachePutIfAbsentCodec.decodeResponse((ClientMessage)message).response);
        if (async) {
            BiConsumer<Boolean, Throwable> callback = !this.statisticsEnabled ? null : this.statsHandler.newOnPutIfAbsentCallback(startNanos);
            this.onPutIfAbsentAsyncInternal(key, value, keyData, valueData, delegatingFuture, callback);
            return delegatingFuture;
        }
        try {
            Boolean response = (Boolean)delegatingFuture.get();
            if (this.statisticsEnabled) {
                this.statsHandler.onPutIfAbsent(startNanos, response);
            }
            this.onPutIfAbsentSyncInternal(key, value, keyData, valueData);
            return response;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    protected void onPutIfAbsentAsyncInternal(K key, V value, Data keyData, Data valueData, ClientDelegatingFuture<Boolean> delegatingFuture, BiConsumer<Boolean, Throwable> callback) {
        ClientCacheProxySupportUtil.addCallback(delegatingFuture, callback);
    }

    protected void onPutIfAbsentSyncInternal(K key, V value, Data keyData, Data valueData) {
    }

    protected void removeAllKeysInternal(Set<? extends K> keys, Collection<Data> dataKeys, long startNanos) {
        int partitionCount = this.getContext().getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.listenerCompleter.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllKeysCodec.encodeRequest(this.nameWithPrefix, dataKeys, completionId);
        try {
            this.invoke(request);
            this.listenerCompleter.waitCompletionLatch((Integer)completionId, null);
            if (this.statisticsEnabled) {
                this.statsHandler.onBatchRemove(startNanos, dataKeys.size());
            }
        }
        catch (Throwable t) {
            this.listenerCompleter.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void removeAllInternal() {
        int partitionCount = this.getContext().getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.listenerCompleter.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllCodec.encodeRequest(this.nameWithPrefix, completionId);
        try {
            this.invoke(request);
            this.listenerCompleter.waitCompletionLatch((Integer)completionId, null);
            if (this.statisticsEnabled) {
                this.statsHandler.getStatistics().setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            this.listenerCompleter.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void clearInternal() {
        ClientMessage request = CacheClearCodec.encodeRequest(this.nameWithPrefix);
        try {
            this.invoke(request);
            if (this.statisticsEnabled) {
                this.statsHandler.getStatistics().setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void addListenerLocally(UUID regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, CacheEventListenerAdaptor<K, V> adaptor) {
        this.listenerCompleter.putListenerIfAbsent(cacheEntryListenerConfiguration, regId);
        CacheEntryListener<K, V> entryListener = adaptor.getCacheEntryListener();
        if (entryListener instanceof Closeable) {
            this.closeableListeners.putIfAbsent(regId, (Closeable)entryListener);
        }
    }

    protected void removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        UUID registrationId = this.listenerCompleter.removeListener(cacheEntryListenerConfiguration);
        if (registrationId != null) {
            Closeable closeable = (Closeable)this.closeableListeners.remove(registrationId);
            IOUtil.closeResource(closeable);
        }
    }

    protected UUID getListenerIdLocal(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        return this.listenerCompleter.getListenerId(cacheEntryListenerConfiguration);
    }

    private void deregisterAllCacheEntryListener(Collection<UUID> listenerRegistrations) {
        ClientListenerService listenerService = this.getContext().getListenerService();
        for (UUID regId : listenerRegistrations) {
            listenerService.deregisterListener(regId);
        }
    }

    protected V getSyncInternal(Object key, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        try {
            ClientDelegatingFuture<V> future = this.getInternal(key, expiryPolicy, false);
            Object value = future.get();
            if (this.statisticsEnabled) {
                this.statsHandler.onGet(startNanos, value != null);
            }
            return value;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    protected InternalCompletableFuture<V> getAsyncInternal(Object key, ExpiryPolicy expiryPolicy, BiConsumer<V, Throwable> callback) {
        Data dataKey = this.toData(key);
        ClientDelegatingFuture<V> future = this.getInternal(dataKey, expiryPolicy, true);
        ClientCacheProxySupportUtil.addCallback(future, callback);
        return future;
    }

    protected void getAllInternal(Set<? extends K> keys, Collection<Data> dataKeys, ExpiryPolicy expiryPolicy, List<Object> resultingKeyValuePairs, long startNanos) {
        if (dataKeys.isEmpty()) {
            CollectionUtil.objectToDataCollection(keys, dataKeys, this.getSerializationService(), "Null key is not allowed!");
        }
        Data expiryPolicyData = this.toData(expiryPolicy);
        ClientMessage request = CacheGetAllCodec.encodeRequest(this.nameWithPrefix, dataKeys, expiryPolicyData);
        ClientMessage responseMessage = (ClientMessage)this.invoke(request);
        List<Map.Entry<Data, Data>> response = CacheGetAllCodec.decodeResponse((ClientMessage)responseMessage).response;
        for (Map.Entry<Data, Data> entry : response) {
            resultingKeyValuePairs.add(entry.getKey());
            resultingKeyValuePairs.add(entry.getValue());
        }
        if (this.statisticsEnabled) {
            this.statsHandler.onBatchGet(startNanos, response.size());
        }
    }

    protected void setExpiryPolicyInternal(Set<? extends K> keys, ExpiryPolicy policy) {
        this.setExpiryPolicyInternal(keys, policy, null);
    }

    protected void setExpiryPolicyInternal(Set<? extends K> keys, ExpiryPolicy policy, Set<Data> serializedKeys) {
        try {
            List<Data>[] keysByPartition = this.groupKeysToPartitions(keys, serializedKeys);
            this.setExpiryPolicyAndWaitForCompletion(keysByPartition, policy);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected void putAllInternal(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition, long startNanos) {
        try {
            this.groupDataToPartitions(map, this.getContext().getPartitionService(), keyMap, entriesPerPartition);
            this.putToAllPartitionsAndWaitForCompletion(entriesPerPartition, expiryPolicy, startNanos);
        }
        catch (Exception t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected boolean containsKeyInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = CacheContainsKeyCodec.encodeRequest(this.nameWithPrefix, keyData);
        ClientMessage result = this.invoke(request, keyData);
        return CacheContainsKeyCodec.decodeResponse((ClientMessage)result).response;
    }

    protected void loadAllInternal(Set<? extends K> keys, List<Data> dataKeys, boolean replaceExistingValues, CompletionListener completionListener) {
        ClientMessage request = CacheLoadAllCodec.encodeRequest(this.nameWithPrefix, dataKeys, replaceExistingValues);
        try {
            this.submitLoadAllTask(request, completionListener, dataKeys);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    protected Object invokeInternal(Object key, Data epData, Object ... arguments) {
        List<Data> argumentsData;
        Data keyData = this.toData(key);
        if (arguments != null) {
            argumentsData = new ArrayList(arguments.length);
            for (int i = 0; i < arguments.length; ++i) {
                argumentsData.add(this.toData(arguments[i]));
            }
        } else {
            argumentsData = Collections.emptyList();
        }
        int completionId = this.nextCompletionId();
        ClientMessage request = CacheEntryProcessorCodec.encodeRequest(this.nameWithPrefix, keyData, epData, argumentsData, completionId);
        try {
            ClientInvocationFuture future = this.invoke(request, keyData, completionId);
            ClientMessage response = ClientCacheProxySupportUtil.getSafely(future);
            Data data = CacheEntryProcessorCodec.decodeResponse((ClientMessage)response).response;
            return this.toObject(data);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new EntryProcessorException((Throwable)e);
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        Collection<Member> members = this.getContext().getClusterService().getMemberList();
        for (Member member : members) {
            try {
                Address address = member.getAddress();
                Data configData = this.toData(cacheEntryListenerConfiguration);
                ClientMessage request = CacheListenerRegistrationCodec.encodeRequest(this.nameWithPrefix, configData, isRegister, address);
                ClientInvocation invocation = new ClientInvocation(this.getClient(), request, (Object)this.getName(), address);
                invocation.invoke();
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
    }

    protected ILogger getLogger() {
        return this.logger;
    }

    private ClientDelegatingFuture<V> getInternal(Object key, ExpiryPolicy expiryPolicy, boolean deserializeResponse) {
        Data keyData = this.toData(key);
        Data expiryPolicyData = this.toData(expiryPolicy);
        ClientMessage request = CacheGetCodec.encodeRequest(this.nameWithPrefix, keyData, expiryPolicyData);
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, (Object)this.name, partitionId);
        ClientInvocationFuture future = clientInvocation.invoke();
        return this.newDelegatingFuture(future, message -> CacheGetCodec.decodeResponse((ClientMessage)message).response, deserializeResponse);
    }

    private void groupDataToPartitions(Map<? extends K, ? extends V> map, ClientPartitionService partitionService, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int partitionId;
            List<Map.Entry<Data, Data>> entries;
            K key = entry.getKey();
            V value = entry.getValue();
            CacheProxyUtil.validateNotNull(key, value);
            Data keyData = this.toData(key);
            Data valueData = this.toData(value);
            if (keyMap != null) {
                keyMap.put(key, keyData);
            }
            if ((entries = entriesPerPartition[partitionId = partitionService.getPartitionId(keyData)]) == null) {
                entriesPerPartition[partitionId] = entries = new ArrayList<Map.Entry<Data, Data>>();
            }
            entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData));
        }
    }

    private List<Data>[] groupKeysToPartitions(Set<? extends K> keys, Set<Data> serializedKeys) {
        List[] keysByPartition = new List[this.partitionCount];
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        for (K key : keys) {
            int partitionId;
            ArrayList partition;
            Object keyData = this.getSerializationService().toData(key);
            if (serializedKeys != null) {
                serializedKeys.add((Data)keyData);
            }
            if ((partition = keysByPartition[partitionId = partitionService.getPartitionId((Data)keyData)]) == null) {
                keysByPartition[partitionId] = partition = new ArrayList();
            }
            partition.add(keyData);
        }
        return keysByPartition;
    }

    private void putToAllPartitionsAndWaitForCompletion(List<Map.Entry<Data, Data>>[] entriesPerPartition, ExpiryPolicy expiryPolicy, long startNanos) {
        Data expiryPolicyData = this.toData(expiryPolicy);
        ArrayList<ClientCacheProxySupportUtil.FutureEntriesTuple> futureEntriesTuples = new ArrayList<ClientCacheProxySupportUtil.FutureEntriesTuple>(entriesPerPartition.length);
        for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
            List<Map.Entry<Data, Data>> entries = entriesPerPartition[partitionId];
            if (entries == null) continue;
            int completionId = this.nextCompletionId();
            ClientMessage request = CachePutAllCodec.encodeRequest(this.nameWithPrefix, entries, expiryPolicyData, completionId);
            ClientInvocationFuture future = this.invoke(request, partitionId, completionId);
            futureEntriesTuples.add(new ClientCacheProxySupportUtil.FutureEntriesTuple(future, entries));
        }
        this.waitResponseFromAllPartitionsForPutAll(futureEntriesTuples, startNanos);
    }

    private void setExpiryPolicyAndWaitForCompletion(List<Data>[] keysByPartition, ExpiryPolicy expiryPolicy) {
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>(keysByPartition.length);
        Data policyData = this.toData(expiryPolicy);
        for (int partitionId = 0; partitionId < keysByPartition.length; ++partitionId) {
            List<Data> keys = keysByPartition[partitionId];
            if (keys == null) continue;
            ClientMessage request = CacheSetExpiryPolicyCodec.encodeRequest(this.nameWithPrefix, keys, policyData);
            futures.add(this.invoke(request, partitionId, -1));
        }
        List<Throwable> throwables = FutureUtil.waitUntilAllResponded(futures);
        if (throwables.size() > 0) {
            throw ExceptionUtil.rethrow(throwables.get(0));
        }
    }

    private void waitResponseFromAllPartitionsForPutAll(List<ClientCacheProxySupportUtil.FutureEntriesTuple> futureEntriesTuples, long startNanos) {
        Throwable error = null;
        for (ClientCacheProxySupportUtil.FutureEntriesTuple tuple : futureEntriesTuples) {
            Future future = tuple.getFuture();
            List<Map.Entry<Data, Data>> entries = tuple.getEntries();
            try {
                future.get();
                if (!this.statisticsEnabled) continue;
                this.statsHandler.getStatistics().increaseCachePuts(entries.size());
            }
            catch (Throwable t) {
                this.logger.finest("Error occurred while putting entries as batch!", t);
                if (error != null) continue;
                error = t;
            }
        }
        if (this.statisticsEnabled) {
            this.statsHandler.getStatistics().addPutTimeNanos(this.nowInNanosOrDefault() - startNanos);
        }
        if (error != null) {
            throw ExceptionUtil.rethrow(error);
        }
    }

    private int nextCompletionId() {
        return this.completionIdCounter.incrementAndGet();
    }

    private void close0(boolean destroy) {
        this.waitOnGoingLoadAllCallsToFinish();
        this.closeListeners();
        if (!destroy) {
            this.resetCacheManager();
        }
    }

    private void waitOnGoingLoadAllCallsToFinish() {
        Iterator iterator = this.loadAllCalls.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Future future = (Future)entry.getKey();
            CompletionListener completionListener = (CompletionListener)entry.getValue();
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                this.logger.finest("Error occurred at loadAll operation execution while waiting it to finish on cache close!", t);
                ClientCacheProxySupportUtil.handleFailureOnCompletionListener(completionListener, t);
            }
            iterator.remove();
        }
    }

    private void closeListeners() {
        this.deregisterAllCacheEntryListener(this.listenerCompleter.getListenersIds(true));
        this.deregisterAllCacheEntryListener(this.listenerCompleter.getListenersIds(false));
        this.listenerCompleter.clearListeners();
        for (Closeable closeable : this.closeableListeners.values()) {
            IOUtil.closeResource(closeable);
        }
    }

    private ClientMessage invoke(ClientMessage clientMessage, Data keyData) {
        try {
            int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, (Object)this.getName(), partitionId).invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void submitLoadAllTask(ClientMessage request, CompletionListener completionListener, List<Data> binaryKeys) {
        CompletionListener listener = completionListener != null ? completionListener : NULL_COMPLETION_LISTENER;
        ClientDelegatingFuture delegatingFuture = null;
        try {
            this.injectDependencies(completionListener);
            long startNanos = this.nowInNanosOrDefault();
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.getName()).invoke();
            ClientDelegatingFuture delFuture = delegatingFuture = this.newDelegatingFuture(future, clientMessage -> Boolean.TRUE);
            this.loadAllCalls.put(delegatingFuture, listener);
            delegatingFuture.whenCompleteAsync((response, t) -> {
                if (t == null) {
                    this.loadAllCalls.remove(delFuture);
                    this.onLoadAll(binaryKeys, response, startNanos);
                    listener.onCompletion();
                } else {
                    this.loadAllCalls.remove(delFuture);
                    ClientCacheProxySupportUtil.handleFailureOnCompletionListener(listener, t);
                }
            });
        }
        catch (Throwable t2) {
            if (delegatingFuture != null) {
                this.loadAllCalls.remove(delegatingFuture);
            }
            ClientCacheProxySupportUtil.handleFailureOnCompletionListener(listener, t2);
        }
    }

    private <T> ClientDelegatingFuture<T> newDelegatingFuture(ClientInvocationFuture future, ClientMessageDecoder decoder) {
        return new ClientDelegatingFuture(future, this.getSerializationService(), decoder);
    }

    private <T> ClientDelegatingFuture<T> newDelegatingFuture(ClientInvocationFuture future, ClientMessageDecoder decoder, boolean deserializeResponse) {
        return new ClientDelegatingFuture(future, this.getSerializationService(), decoder, deserializeResponse);
    }

    private <T> ClientDelegatingFuture<T> getAndRemoveInternal(Data keyData, boolean withCompletionEvent) {
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndRemoveCodec.encodeRequest(this.nameWithPrefix, keyData, completionId);
        ClientInvocationFuture future = this.invoke(request, keyData, completionId);
        return this.newDelegatingFuture(future, clientMessage -> CacheGetAndRemoveCodec.decodeResponse((ClientMessage)clientMessage).response);
    }

    private ClientInvocationFuture putInternal(Data keyData, Data valueData, Data expiryPolicyData, boolean isGet, boolean withCompletionEvent) {
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutCodec.encodeRequest(this.nameWithPrefix, keyData, valueData, expiryPolicyData, isGet, completionId);
        return this.invoke(request, keyData, completionId);
    }
}

