/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddClusterViewListenerCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.cluster.impl.MembershipManager;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientClusterListenerService {
    private final Map<ClientEndpoint, Long> clusterListeningEndpoints = new ConcurrentHashMap<ClientEndpoint, Long>();
    private final NodeEngine nodeEngine;
    private final boolean advancedNetworkConfigEnabled;

    ClientClusterListenerService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.advancedNetworkConfigEnabled = nodeEngine.getConfig().getAdvancedNetworkConfig().isEnabled();
    }

    public void onPartitionStateChange() {
        this.onClusterViewChange();
    }

    public void onMemberListChange() {
        this.onClusterViewChange();
    }

    private void onClusterViewChange() {
        ClientMessage clientMessage = this.getClusterViewMessage();
        for (Map.Entry<ClientEndpoint, Long> entry : this.clusterListeningEndpoints.entrySet()) {
            Long correlationId = entry.getValue();
            ClientMessage message = clientMessage.copyWithNewCorrelationId(correlationId);
            ClientEndpoint clientEndpoint = entry.getKey();
            Connection connection = clientEndpoint.getConnection();
            connection.write(message);
        }
    }

    public void registerListener(ClientEndpoint clientEndpoint, long correlationId) {
        this.clusterListeningEndpoints.put(clientEndpoint, correlationId);
        ClientMessage clientMessage = this.getClusterViewMessage();
        clientMessage.setCorrelationId(correlationId);
        clientEndpoint.getConnection().write(clientMessage);
    }

    private ClientMessage getClusterViewMessage() {
        MembershipManager membershipManager = ((ClusterServiceImpl)this.nodeEngine.getClusterService()).getMembershipManager();
        MembersView membersView = membershipManager.getMembersView();
        int version = membersView.getVersion();
        List<MemberInfo> members = membersView.getMembers();
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        for (MemberInfo member : members) {
            memberInfos.add(new MemberInfo(this.clientAddressOf(member.getAddress()), member.getUuid(), member.getAttributes(), member.isLiteMember(), member.getVersion()));
        }
        InternalPartitionService partitionService = (InternalPartitionService)this.nodeEngine.getPartitionService();
        PartitionTableView partitionTableView = partitionService.createPartitionTableView();
        Map<Address, List<Integer>> partitions = this.getPartitions(partitionTableView);
        int partitionStateVersion = partitionTableView.getVersion();
        return ClientAddClusterViewListenerCodec.encodeMembersViewEvent(version, memberInfos, partitions.entrySet(), partitionStateVersion);
    }

    public void deregisterListener(ClientEndpoint clientEndpoint) {
        this.clusterListeningEndpoints.remove(clientEndpoint);
    }

    private Address clientAddressOf(Address memberAddress) {
        if (!this.advancedNetworkConfigEnabled) {
            return memberAddress;
        }
        MemberImpl member = this.nodeEngine.getClusterService().getMember(memberAddress);
        if (member != null) {
            return member.getAddressMap().get(EndpointQualifier.CLIENT);
        }
        return null;
    }

    public Map<Address, List<Integer>> getPartitions(PartitionTableView partitionTableView) {
        HashMap<Address, List<Integer>> partitionsMap = new HashMap<Address, List<Integer>>();
        int partitionCount = partitionTableView.getLength();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            PartitionReplica owner = partitionTableView.getReplica(partitionId, 0);
            if (owner == null) {
                partitionsMap.clear();
                return partitionsMap;
            }
            Address clientOwnerAddress = this.clientAddressOf(owner.address());
            if (clientOwnerAddress == null) {
                partitionsMap.clear();
                return partitionsMap;
            }
            LinkedList<Integer> indexes = (LinkedList<Integer>)partitionsMap.get(clientOwnerAddress);
            if (indexes == null) {
                indexes = new LinkedList<Integer>();
                partitionsMap.put(clientOwnerAddress, indexes);
            }
            indexes.add(partitionId);
        }
        return partitionsMap;
    }
}

