/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.UndefinedErrorCodeException;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ErrorsCodec;
import com.hazelcast.client.impl.protocol.exception.ErrorHolder;
import com.hazelcast.client.impl.protocol.exception.MaxMessageSizeExceeded;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.ConsistencyLostException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.IndeterminateOperationStateException;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.cp.exception.CannotReplicateException;
import com.hazelcast.cp.exception.LeaderDemotedException;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.exception.StaleAppendRequestException;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.session.SessionExpiredException;
import com.hazelcast.cp.lock.exception.LockAcquireLimitReachedException;
import com.hazelcast.cp.lock.exception.LockOwnershipLostException;
import com.hazelcast.crdt.MutationDisallowedException;
import com.hazelcast.crdt.TargetNotReplicaException;
import com.hazelcast.durableexecutor.StaleTaskIdException;
import com.hazelcast.flakeidgen.impl.NodeIdOutOfRangeException;
import com.hazelcast.internal.cluster.impl.ConfigMismatchException;
import com.hazelcast.internal.cluster.impl.VersionMismatchException;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.query.QueryException;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.scheduledexecutor.DuplicateTaskException;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.hazelcast.topic.TopicOverloadException;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionTimedOutException;
import com.hazelcast.wan.WanReplicationQueueFullException;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.UTFDataFormatException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessorException;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.XAException;

public class ClientExceptionFactory {
    private final Map<Integer, ExceptionFactory> intToFactory = new HashMap<Integer, ExceptionFactory>();

    public ClientExceptionFactory(boolean jcacheAvailable) {
        if (jcacheAvailable) {
            this.register(4, CacheException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new CacheException(message, cause);
                }
            });
            this.register(5, CacheLoaderException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new CacheLoaderException(message, cause);
                }
            });
            this.register(7, CacheWriterException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new CacheWriterException(message, cause);
                }
            });
            this.register(18, EntryProcessorException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new EntryProcessorException(message, cause);
                }
            });
        }
        this.register(1, ArrayIndexOutOfBoundsException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ArrayIndexOutOfBoundsException(message);
            }
        });
        this.register(2, ArrayStoreException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ArrayStoreException(message);
            }
        });
        this.register(3, AuthenticationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AuthenticationException(message);
            }
        });
        this.register(6, CacheNotExistsException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CacheNotExistsException(message);
            }
        });
        this.register(8, CallerNotMemberException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CallerNotMemberException(message);
            }
        });
        this.register(9, CancellationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CancellationException(message);
            }
        });
        this.register(10, ClassCastException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ClassCastException(message);
            }
        });
        this.register(11, ClassNotFoundException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ClassNotFoundException(message, cause);
            }
        });
        this.register(12, ConcurrentModificationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ConcurrentModificationException(message);
            }
        });
        this.register(13, ConfigMismatchException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ConfigMismatchException(message);
            }
        });
        this.register(15, DistributedObjectDestroyedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new DistributedObjectDestroyedException(message);
            }
        });
        this.register(17, EOFException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new EOFException(message);
            }
        });
        this.register(19, ExecutionException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ExecutionException(message, cause);
            }
        });
        this.register(20, HazelcastException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastException(message, cause);
            }
        });
        this.register(21, HazelcastInstanceNotActiveException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastInstanceNotActiveException(message);
            }
        });
        this.register(22, HazelcastOverloadException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastOverloadException(message);
            }
        });
        this.register(23, HazelcastSerializationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastSerializationException(message, cause);
            }
        });
        this.register(24, IOException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IOException(message, cause);
            }
        });
        this.register(25, IllegalArgumentException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalArgumentException(message, cause);
            }
        });
        this.register(26, IllegalAccessException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalAccessException(message);
            }
        });
        this.register(27, IllegalAccessError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalAccessError(message);
            }
        });
        this.register(28, IllegalMonitorStateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalMonitorStateException(message);
            }
        });
        this.register(29, IllegalStateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalStateException(message, cause);
            }
        });
        this.register(30, IllegalThreadStateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalThreadStateException(message);
            }
        });
        this.register(31, IndexOutOfBoundsException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IndexOutOfBoundsException(message);
            }
        });
        this.register(32, InterruptedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new InterruptedException(message);
            }
        });
        this.register(33, AddressUtil.InvalidAddressException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AddressUtil.InvalidAddressException(message, false);
            }
        });
        this.register(34, InvalidConfigurationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new InvalidConfigurationException(message, cause);
            }
        });
        this.register(35, MemberLeftException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new MemberLeftException(message);
            }
        });
        this.register(36, NegativeArraySizeException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NegativeArraySizeException(message);
            }
        });
        this.register(37, NoSuchElementException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NoSuchElementException(message);
            }
        });
        this.register(38, NotSerializableException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NotSerializableException(message);
            }
        });
        this.register(39, NullPointerException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NullPointerException(message);
            }
        });
        this.register(40, OperationTimeoutException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new OperationTimeoutException(message);
            }
        });
        this.register(41, PartitionMigratingException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new PartitionMigratingException(message);
            }
        });
        this.register(42, QueryException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new QueryException(message, cause);
            }
        });
        this.register(43, QueryResultSizeExceededException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new QueryResultSizeExceededException(message);
            }
        });
        this.register(44, SplitBrainProtectionException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new SplitBrainProtectionException(message);
            }
        });
        this.register(45, ReachedMaxSizeException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ReachedMaxSizeException(message);
            }
        });
        this.register(46, RejectedExecutionException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RejectedExecutionException(message, cause);
            }
        });
        this.register(48, ResponseAlreadySentException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ResponseAlreadySentException(message);
            }
        });
        this.register(49, RetryableHazelcastException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RetryableHazelcastException(message, cause);
            }
        });
        this.register(50, RetryableIOException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RetryableIOException(message, cause);
            }
        });
        this.register(51, RuntimeException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RuntimeException(message, cause);
            }
        });
        this.register(52, SecurityException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new SecurityException(message, cause);
            }
        });
        this.register(53, SocketException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new SocketException(message);
            }
        });
        this.register(54, StaleSequenceException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new StaleSequenceException(message, 0L);
            }
        });
        this.register(55, TargetDisconnectedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TargetDisconnectedException(message);
            }
        });
        this.register(56, TargetNotMemberException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TargetNotMemberException(message);
            }
        });
        this.register(57, TimeoutException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TimeoutException(message);
            }
        });
        this.register(58, TopicOverloadException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TopicOverloadException(message);
            }
        });
        this.register(60, TransactionException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TransactionException(message, cause);
            }
        });
        this.register(61, TransactionNotActiveException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TransactionNotActiveException(message);
            }
        });
        this.register(62, TransactionTimedOutException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TransactionTimedOutException(message, cause);
            }
        });
        this.register(63, URISyntaxException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new URISyntaxException("not available", message);
            }
        });
        this.register(64, UTFDataFormatException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new UTFDataFormatException(message);
            }
        });
        this.register(65, UnsupportedOperationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new UnsupportedOperationException(message, cause);
            }
        });
        this.register(66, WrongTargetException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new WrongTargetException(message);
            }
        });
        this.register(67, XAException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new XAException(message);
            }
        });
        this.register(68, AccessControlException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AccessControlException(message);
            }
        });
        this.register(69, LoginException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new LoginException(message);
            }
        });
        this.register(70, UnsupportedCallbackException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new UnsupportedCallbackException(null, message);
            }
        });
        this.register(71, NoDataMemberInClusterException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NoDataMemberInClusterException(message);
            }
        });
        this.register(72, ReplicatedMapCantBeCreatedOnLiteMemberException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ReplicatedMapCantBeCreatedOnLiteMemberException(message);
            }
        });
        this.register(73, MaxMessageSizeExceeded.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new MaxMessageSizeExceeded(message);
            }
        });
        this.register(74, WanReplicationQueueFullException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new WanReplicationQueueFullException(message);
            }
        });
        this.register(75, AssertionError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AssertionError((Object)message);
            }
        });
        this.register(76, OutOfMemoryError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new OutOfMemoryError(message);
            }
        });
        this.register(77, StackOverflowError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new StackOverflowError(message);
            }
        });
        this.register(78, NativeOutOfMemoryError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NativeOutOfMemoryError(message, cause);
            }
        });
        this.register(79, ServiceNotFoundException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ServiceNotFoundException(message);
            }
        });
        this.register(80, StaleTaskIdException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new StaleTaskIdException(message);
            }
        });
        this.register(81, DuplicateTaskException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new DuplicateTaskException(message);
            }
        });
        this.register(82, StaleTaskException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new StaleTaskException(message);
            }
        });
        this.register(83, LocalMemberResetException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new LocalMemberResetException(message);
            }
        });
        this.register(84, IndeterminateOperationStateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IndeterminateOperationStateException(message, cause);
            }
        });
        this.register(85, NodeIdOutOfRangeException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NodeIdOutOfRangeException(message);
            }
        });
        this.register(86, TargetNotReplicaException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TargetNotReplicaException(message);
            }
        });
        this.register(87, MutationDisallowedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new MutationDisallowedException(message);
            }
        });
        this.register(88, ConsistencyLostException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ConsistencyLostException(message);
            }
        });
        this.register(89, SessionExpiredException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new SessionExpiredException(message, cause);
            }
        });
        this.register(90, WaitKeyCancelledException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new WaitKeyCancelledException(message, cause);
            }
        });
        this.register(91, LockAcquireLimitReachedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new LockAcquireLimitReachedException(message);
            }
        });
        this.register(92, LockOwnershipLostException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new LockOwnershipLostException(message);
            }
        });
        this.register(93, CPGroupDestroyedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CPGroupDestroyedException();
            }
        });
        this.register(94, CannotReplicateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CannotReplicateException(null);
            }
        });
        this.register(95, LeaderDemotedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new LeaderDemotedException(null, null);
            }
        });
        this.register(96, StaleAppendRequestException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new StaleAppendRequestException(null);
            }
        });
        this.register(97, NotLeaderException.class, (message, cause) -> new NotLeaderException(null, null, null));
        this.register(98, VersionMismatchException.class, (message, cause) -> new VersionMismatchException(message));
    }

    public Throwable createException(ClientMessage clientMessage) {
        List<ErrorHolder> errorHolders = ErrorsCodec.decode(clientMessage);
        return this.createException(errorHolders.iterator());
    }

    private Throwable createException(Iterator<ErrorHolder> iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        ErrorHolder errorHolder = iterator.next();
        ExceptionFactory exceptionFactory = this.intToFactory.get(errorHolder.getErrorCode());
        Throwable throwable = exceptionFactory == null ? new UndefinedErrorCodeException(errorHolder.getMessage(), errorHolder.getClassName()) : exceptionFactory.createException(errorHolder.getMessage(), this.createException(iterator));
        throwable.setStackTrace(errorHolder.getStackTraceElements().toArray(new StackTraceElement[0]));
        return throwable;
    }

    public void register(int errorCode, Class clazz, ExceptionFactory exceptionFactory) {
        if (this.intToFactory.containsKey(errorCode)) {
            throw new HazelcastException("Code " + errorCode + " already used");
        }
        if (!clazz.equals(exceptionFactory.createException("", null).getClass())) {
            throw new HazelcastException("Exception factory did not produce an instance of expected class");
        }
        this.intToFactory.put(errorCode, exceptionFactory);
    }

    public static interface ExceptionFactory {
        public Throwable createException(String var1, Throwable var2);
    }
}

