/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.nio;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.EndpointManager;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.security.cert.Certificate;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class ClientConnection
implements Connection {
    @Probe
    private final int connectionId;
    private final ILogger logger;
    private final Channel channel;
    private final ClientConnectionManagerImpl connectionManager;
    private final LifecycleService lifecycleService;
    private final HazelcastClientInstanceImpl client;
    private final long startTime = System.currentTimeMillis();
    private final Consumer<ClientMessage> responseHandler;
    private final ConcurrentMap attributeMap;
    private volatile Address remoteEndpoint;
    @Probe(level=ProbeLevel.DEBUG)
    private final AtomicLong closedTime = new AtomicLong();
    private volatile Throwable closeCause;
    private volatile String closeReason;
    private String connectedServerVersion;

    public ClientConnection(HazelcastClientInstanceImpl client, int connectionId, Channel channel) {
        this.client = client;
        this.responseHandler = client.getInvocationService().getResponseHandler();
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.channel = channel;
        this.attributeMap = channel.attributeMap();
        this.attributeMap.put(ClientConnection.class, this);
        this.connectionId = connectionId;
        this.logger = client.getLoggingService().getLogger(ClientConnection.class);
    }

    public ClientConnection(HazelcastClientInstanceImpl client, int connectionId) {
        this.client = client;
        this.responseHandler = client.getInvocationService().getResponseHandler();
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.connectionId = connectionId;
        this.channel = null;
        this.attributeMap = null;
        this.logger = client.getLoggingService().getLogger(ClientConnection.class);
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.channel.write(frame)) {
            return true;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Connection is closed, dropping frame -> " + frame);
        }
        return false;
    }

    @Override
    public Address getEndPoint() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean isAlive() {
        return this.closedTime.get() == 0L;
    }

    @Override
    public long lastReadTimeMillis() {
        return this.channel.lastReadTimeMillis();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.channel.lastWriteTimeMillis();
    }

    @Override
    public void setConnectionType(String connectionType) {
    }

    @Override
    public String getConnectionType() {
        return "JVM";
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.channel.remoteSocketAddress();
    }

    @Override
    public int getPort() {
        return this.channel.socket().getPort();
    }

    @Override
    public EndpointManager getEndpointManager() {
        throw new UnsupportedOperationException();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setRemoteEndpoint(Address remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.channel.localSocketAddress();
    }

    @Override
    public void close(String reason, Throwable cause) {
        if (!this.closedTime.compareAndSet(0L, System.currentTimeMillis())) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        this.logClose();
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning("Exception while closing connection" + e.getMessage());
        }
        this.connectionManager.onClose(this);
    }

    private void logClose() {
        String message = this.toString() + " closed. Reason: ";
        message = this.closeReason != null ? message + this.closeReason : (this.closeCause != null ? message + this.closeCause.getClass().getName() + "[" + this.closeCause.getMessage() + "]" : message + "Socket explicitly closed");
        if (this.lifecycleService.isRunning()) {
            if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
                this.logger.info(message);
            } else {
                this.logger.warning(message, this.closeCause);
            }
        } else if (this.closeCause == null) {
            this.logger.finest(message);
        } else {
            this.logger.finest(message, this.closeCause);
        }
    }

    protected void innerClose() throws IOException {
        this.channel.close();
    }

    @Override
    public Throwable getCloseCause() {
        return this.closeCause;
    }

    @Override
    public String getCloseReason() {
        if (this.closeReason == null) {
            return this.closeCause == null ? null : this.closeCause.getMessage();
        }
        return this.closeReason;
    }

    public void handleClientMessage(ClientMessage message) {
        if (ClientMessage.isFlagSet(message.getHeaderFlags(), 128)) {
            this.responseHandler.accept(message);
        } else if (ClientMessage.isFlagSet(message.getHeaderFlags(), 512)) {
            ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)this.client.getListenerService();
            listenerService.handleEventMessage(message);
        } else {
            this.responseHandler.accept(message);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        return "ClientConnection{alive=" + this.isAlive() + ", connectionId=" + this.connectionId + ", channel=" + this.channel + ", remoteEndpoint=" + this.remoteEndpoint + ", lastReadTime=" + StringUtil.timeToStringFriendly(this.lastReadTimeMillis()) + ", lastWriteTime=" + StringUtil.timeToStringFriendly(this.lastWriteTimeMillis()) + ", closedTime=" + StringUtil.timeToStringFriendly(this.closedTime.get()) + ", connected server version=" + this.connectedServerVersion + '}';
    }

    public void setConnectedServerVersion(String connectedServerVersion) {
        this.connectedServerVersion = connectedServerVersion;
    }

    public String getConnectedServerVersion() {
        return this.connectedServerVersion;
    }

    @Override
    public Certificate[] getRemoteCertificates() {
        return this.attributeMap != null ? (Certificate[])this.attributeMap.get(Certificate.class) : null;
    }
}

