/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.management;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.management.MCClusterMetadata;
import com.hazelcast.client.impl.management.MCMapConfig;
import com.hazelcast.client.impl.management.UpdateMapConfigParameters;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCApplyMCConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCChangeClusterStateCodec;
import com.hazelcast.client.impl.protocol.codec.MCChangeClusterVersionCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetClusterMetadataCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetMapConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetMemberConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetSystemPropertiesCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetThreadDumpCodec;
import com.hazelcast.client.impl.protocol.codec.MCGetTimedMemberStateCodec;
import com.hazelcast.client.impl.protocol.codec.MCMatchMCConfigCodec;
import com.hazelcast.client.impl.protocol.codec.MCPromoteLiteMemberCodec;
import com.hazelcast.client.impl.protocol.codec.MCReadMetricsCodec;
import com.hazelcast.client.impl.protocol.codec.MCRunConsoleCommandCodec;
import com.hazelcast.client.impl.protocol.codec.MCRunGcCodec;
import com.hazelcast.client.impl.protocol.codec.MCRunScriptCodec;
import com.hazelcast.client.impl.protocol.codec.MCShutdownClusterCodec;
import com.hazelcast.client.impl.protocol.codec.MCShutdownMemberCodec;
import com.hazelcast.client.impl.protocol.codec.MCUpdateMapConfigCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.management.dto.ClientBwListDTO;
import com.hazelcast.internal.metrics.managementcenter.MetricsResultSet;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.version.Version;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class ManagementCenterService {
    public static final HazelcastProperty MC_CLIENT_MODE_PROP = new HazelcastProperty("hazelcast.client.internal.mc.mode", false);
    private final HazelcastClientInstanceImpl client;
    private final InternalSerializationService serializationService;

    public ManagementCenterService(HazelcastClientInstanceImpl client, InternalSerializationService serializationService) {
        this.client = client;
        this.serializationService = serializationService;
    }

    @Nonnull
    public CompletableFuture<MetricsResultSet> readMetricsAsync(Member member, long startSequence) {
        ClientMessage request = MCReadMetricsCodec.encodeRequest(member.getUuid(), startSequence);
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, member.getAddress());
        ClientMessageDecoder<MetricsResultSet> decoder = clientMessage -> {
            MCReadMetricsCodec.ResponseParameters response = MCReadMetricsCodec.decodeResponse(clientMessage);
            return new MetricsResultSet(response.nextSequence, response.elements);
        };
        return new ClientDelegatingFuture<MetricsResultSet>(invocation.invoke(), (SerializationService)this.serializationService, decoder, false);
    }

    @Nonnull
    public CompletableFuture<Void> changeClusterState(ClusterState newState) {
        Preconditions.checkNotNull(newState);
        ClientInvocation invocation = new ClientInvocation(this.client, MCChangeClusterStateCodec.encodeRequest(newState.getId()), null);
        return new ClientDelegatingFuture<Void>(invocation.invoke(), this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<MCMapConfig> getMapConfig(String map) {
        Preconditions.checkNotNull(map);
        return this.doGetMapConfig(null, map);
    }

    @Nonnull
    public CompletableFuture<MCMapConfig> getMapConfig(Member member, String map) {
        Preconditions.checkNotNull(member);
        Preconditions.checkNotNull(map);
        return this.doGetMapConfig(member, map);
    }

    private CompletableFuture<MCMapConfig> doGetMapConfig(Member member, String map) {
        ClientInvocation invocation = member == null ? new ClientInvocation(this.client, MCGetMapConfigCodec.encodeRequest(map), map) : new ClientInvocation(this.client, MCGetMapConfigCodec.encodeRequest(map), (Object)map, member.getAddress());
        return new ClientDelegatingFuture<MCMapConfig>(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> {
            MCGetMapConfigCodec.ResponseParameters response = MCGetMapConfigCodec.decodeResponse(clientMessage);
            return MCMapConfig.fromResponse(response);
        }, true);
    }

    @Nonnull
    public CompletableFuture<Void> updateMapConfig(Member member, UpdateMapConfigParameters parameters) {
        Preconditions.checkNotNull(member);
        Preconditions.checkNotNull(parameters);
        Preconditions.checkNotNull(parameters.getEvictionPolicy());
        Preconditions.checkNotNull(parameters.getMaxSizePolicy());
        ClientInvocation invocation = new ClientInvocation(this.client, MCUpdateMapConfigCodec.encodeRequest(parameters.getMap(), parameters.getTimeToLiveSeconds(), parameters.getMaxIdleSeconds(), parameters.getEvictionPolicy().getId(), parameters.isReadBackupData(), parameters.getMaxSize(), parameters.getMaxSizePolicy().getId()), (Object)parameters.getMap(), member.getAddress());
        return new ClientDelegatingFuture<Void>(invocation.invoke(), this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<String> getMemberConfig(Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCGetMemberConfigCodec.encodeRequest(), null, member.getAddress());
        return new ClientDelegatingFuture<String>(invocation.invoke(), this.serializationService, clientMessage -> MCGetMemberConfigCodec.decodeResponse((ClientMessage)clientMessage).configXml);
    }

    @Nonnull
    public CompletableFuture<Void> runGc(Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCRunGcCodec.encodeRequest(), null, member.getAddress());
        return new ClientDelegatingFuture<Void>(invocation.invoke(), this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<String> getThreadDump(Member member, boolean dumpDeadLocks) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCGetThreadDumpCodec.encodeRequest(dumpDeadLocks), null, member.getAddress());
        return new ClientDelegatingFuture<String>(invocation.invoke(), this.serializationService, clientMessage -> MCGetThreadDumpCodec.decodeResponse((ClientMessage)clientMessage).threadDump);
    }

    public void shutdownMember(Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCShutdownMemberCodec.encodeRequest(), null, member.getAddress());
        invocation.invoke();
    }

    @Nonnull
    public CompletableFuture<Void> promoteLiteMember(Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCPromoteLiteMemberCodec.encodeRequest(), null, member.getAddress());
        return new ClientDelegatingFuture<Void>(invocation.invoke(), this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<Map<String, String>> getSystemProperties(Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCGetSystemPropertiesCodec.encodeRequest(), null, member.getAddress());
        return new ClientDelegatingFuture<Map<String, String>>(invocation.invoke(), this.serializationService, clientMessage -> {
            List<Map.Entry<String, String>> systemProperties = MCGetSystemPropertiesCodec.decodeResponse((ClientMessage)clientMessage).systemProperties;
            Map<String, String> result = MapUtil.createHashMap(systemProperties.size());
            for (Map.Entry<String, String> property : systemProperties) {
                result.put(property.getKey(), property.getValue());
            }
            return result;
        });
    }

    @Nonnull
    public CompletableFuture<Optional<String>> getTimedMemberState(Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCGetTimedMemberStateCodec.encodeRequest(), null, member.getAddress());
        return new ClientDelegatingFuture<Optional<String>>(invocation.invoke(), this.serializationService, clientMessage -> Optional.ofNullable(MCGetTimedMemberStateCodec.decodeResponse((ClientMessage)clientMessage).timedMemberStateJson));
    }

    @Nonnull
    public CompletableFuture<Boolean> matchMCConfig(Member member, String eTag) {
        Preconditions.checkNotNull(member);
        Preconditions.checkNotNull(eTag);
        ClientInvocation invocation = new ClientInvocation(this.client, MCMatchMCConfigCodec.encodeRequest(eTag), null, member.getAddress());
        return new ClientDelegatingFuture<Boolean>(invocation.invoke(), (SerializationService)this.serializationService, clientMessage -> {
            MCMatchMCConfigCodec.ResponseParameters response = MCMatchMCConfigCodec.decodeResponse(clientMessage);
            return response.result;
        }, false);
    }

    @Nonnull
    public CompletableFuture<Void> applyMCConfig(Member member, String eTag, ClientBwListDTO clientBwList) {
        Preconditions.checkNotNull(member);
        Preconditions.checkNotNull(eTag);
        Preconditions.checkNotNull(clientBwList);
        Preconditions.checkNotNull(clientBwList.mode);
        Preconditions.checkNotNull(clientBwList.entries);
        ClientInvocation invocation = new ClientInvocation(this.client, MCApplyMCConfigCodec.encodeRequest(eTag, clientBwList.mode.getId(), clientBwList.entries), null, member.getAddress());
        return new ClientDelegatingFuture<Void>(invocation.invoke(), this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<MCClusterMetadata> getClusterMetadata(Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(this.client, MCGetClusterMetadataCodec.encodeRequest(), null, member.getAddress());
        return new ClientDelegatingFuture<MCClusterMetadata>(invocation.invoke(), this.serializationService, clientMessage -> {
            MCGetClusterMetadataCodec.ResponseParameters response = MCGetClusterMetadataCodec.decodeResponse(clientMessage);
            return MCClusterMetadata.fromResponse(response);
        });
    }

    public void shutdownCluster() {
        ClientInvocation invocation = new ClientInvocation(this.client, MCShutdownClusterCodec.encodeRequest(), null);
        invocation.invoke();
    }

    @Nonnull
    public CompletableFuture<Void> changeClusterVersion(Version version) {
        ClientInvocation invocation = new ClientInvocation(this.client, MCChangeClusterVersionCodec.encodeRequest(version.getMajor(), version.getMinor()), null);
        return new ClientDelegatingFuture<Void>(invocation.invoke(), this.serializationService, clientMessage -> null);
    }

    @Nonnull
    public CompletableFuture<String> runScript(Member member, String engine, String script) {
        Preconditions.checkNotNull(member);
        Preconditions.checkNotNull(script);
        Preconditions.checkNotNull(engine);
        ClientInvocation invocation = new ClientInvocation(this.client, MCRunScriptCodec.encodeRequest(engine, script), null, member.getAddress());
        return new ClientDelegatingFuture<String>(invocation.invoke(), this.serializationService, clientMessage -> MCRunScriptCodec.decodeResponse((ClientMessage)clientMessage).result);
    }

    @Nonnull
    public CompletableFuture<String> runConsoleCommand(Member member, String namespace, String command) {
        Preconditions.checkNotNull(member);
        Preconditions.checkNotNull(command);
        ClientInvocation invocation = new ClientInvocation(this.client, MCRunConsoleCommandCodec.encodeRequest(namespace, command), null, member.getAddress());
        return new ClientDelegatingFuture<String>(invocation.invoke(), this.serializationService, clientMessage -> MCRunConsoleCommandCodec.decodeResponse((ClientMessage)clientMessage).result);
    }
}

