/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class CacheManagementConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x131100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x131101;
    private static final int REQUEST_IS_STAT_FIELD_OFFSET = 16;
    private static final int REQUEST_ENABLED_FIELD_OFFSET = 17;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 18;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private CacheManagementConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean isStat, boolean enabled, Address address) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Cache.ManagementConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[18], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x131100);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, isStat);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, enabled);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        AddressCodec.encode(clientMessage, address);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.isStat = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        request.name = StringCodec.decode(iterator);
        request.address = AddressCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x131101);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean isStat;
        public boolean enabled;
        public Address address;
    }
}

