/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.RaftGroupIdCodec;
import com.hazelcast.cp.internal.RaftGroupId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class FencedLockGetLockOwnershipCodec {
    public static final int REQUEST_MESSAGE_TYPE = 459776;
    public static final int RESPONSE_MESSAGE_TYPE = 459777;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_FENCE_FIELD_OFFSET = 16;
    private static final int RESPONSE_LOCK_COUNT_FIELD_OFFSET = 24;
    private static final int RESPONSE_SESSION_ID_FIELD_OFFSET = 28;
    private static final int RESPONSE_THREAD_ID_FIELD_OFFSET = 36;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 44;

    private FencedLockGetLockOwnershipCodec() {
    }

    public static ClientMessage encodeRequest(RaftGroupId groupId, String name) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("FencedLock.GetLockOwnership");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 459776);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.groupId = RaftGroupIdCodec.decode(iterator);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(long fence, int lockCount, long sessionId, long threadId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[44], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 459777);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, fence);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, lockCount);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 28, sessionId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 36, threadId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.fence = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        response.lockCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        response.sessionId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 28);
        response.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 36);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long fence;
        public int lockCount;
        public long sessionId;
        public long threadId;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public RaftGroupId groupId;
        public String name;
    }
}

