/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class MCGetMapConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x200300;
    public static final int RESPONSE_MESSAGE_TYPE = 2097921;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_IN_MEMORY_FORMAT_FIELD_OFFSET = 16;
    private static final int RESPONSE_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int RESPONSE_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 24;
    private static final int RESPONSE_TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 28;
    private static final int RESPONSE_MAX_IDLE_SECONDS_FIELD_OFFSET = 32;
    private static final int RESPONSE_MAX_SIZE_FIELD_OFFSET = 36;
    private static final int RESPONSE_MAX_SIZE_POLICY_FIELD_OFFSET = 40;
    private static final int RESPONSE_READ_BACKUP_DATA_FIELD_OFFSET = 44;
    private static final int RESPONSE_EVICTION_POLICY_FIELD_OFFSET = 45;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 49;

    private MCGetMapConfigCodec() {
    }

    public static ClientMessage encodeRequest(String mapName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MC.GetMapConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x200300);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mapName);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.mapName = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(int inMemoryFormat, int backupCount, int asyncBackupCount, int timeToLiveSeconds, int maxIdleSeconds, int maxSize, int maxSizePolicy, boolean readBackupData, int evictionPolicy, String mergePolicy) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[49], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2097921);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, inMemoryFormat);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, timeToLiveSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 32, maxIdleSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 36, maxSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 40, maxSizePolicy);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 44, readBackupData);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 45, evictionPolicy);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mergePolicy);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.inMemoryFormat = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        response.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        response.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        response.timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        response.maxIdleSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 32);
        response.maxSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 36);
        response.maxSizePolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 40);
        response.readBackupData = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 44);
        response.evictionPolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 45);
        response.mergePolicy = StringCodec.decode(iterator);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public int inMemoryFormat;
        public int backupCount;
        public int asyncBackupCount;
        public int timeToLiveSeconds;
        public int maxIdleSeconds;
        public int maxSize;
        public int maxSizePolicy;
        public boolean readBackupData;
        public int evictionPolicy;
        public String mergePolicy;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String mapName;
    }
}

