/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class ScheduledExecutorSubmitToAddressCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1704704;
    public static final int RESPONSE_MESSAGE_TYPE = 1704705;
    private static final int REQUEST_TYPE_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_DELAY_IN_MILLIS_FIELD_OFFSET = 17;
    private static final int REQUEST_PERIOD_IN_MILLIS_FIELD_OFFSET = 25;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 33;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private ScheduledExecutorSubmitToAddressCodec() {
    }

    public static ClientMessage encodeRequest(String schedulerName, Address address, byte type, String taskName, Data task, long initialDelayInMillis, long periodInMillis) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("ScheduledExecutor.SubmitToAddress");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1704704);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 16, type);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 17, initialDelayInMillis);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 25, periodInMillis);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, schedulerName);
        AddressCodec.encode(clientMessage, address);
        StringCodec.encode(clientMessage, taskName);
        DataCodec.encode(clientMessage, task);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.type = FixedSizeTypesCodec.decodeByte(initialFrame.content, 16);
        request.initialDelayInMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 17);
        request.periodInMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 25);
        request.schedulerName = StringCodec.decode(iterator);
        request.address = AddressCodec.decode(iterator);
        request.taskName = StringCodec.decode(iterator);
        request.task = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1704705);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String schedulerName;
        public Address address;
        public byte type;
        public String taskName;
        public Data task;
        public long initialDelayInMillis;
        public long periodInMillis;
    }
}

