/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.nio.serialization.Data;

public final class ListenerConfigHolderCodec {
    private static final int LISTENER_TYPE_FIELD_OFFSET = 0;
    private static final int INCLUDE_VALUE_FIELD_OFFSET = 4;
    private static final int LOCAL_FIELD_OFFSET = 5;
    private static final int INITIAL_FRAME_SIZE = 6;

    private ListenerConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, ListenerConfigHolder listenerConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[6]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, listenerConfigHolder.getListenerType());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 4, listenerConfigHolder.isIncludeValue());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 5, listenerConfigHolder.isLocal());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, listenerConfigHolder.getListenerImplementation(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, listenerConfigHolder.getClassName(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static ListenerConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int listenerType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        boolean includeValue = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 4);
        boolean local = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 5);
        Data listenerImplementation = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        String className = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new ListenerConfigHolder(listenerType, listenerImplementation, className, includeValue, local);
    }
}

