/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import java.util.Map;
import java.util.UUID;

public final class MemberCodec {
    private static final int UUID_FIELD_OFFSET = 0;
    private static final int LITE_MEMBER_FIELD_OFFSET = 17;
    private static final int INITIAL_FRAME_SIZE = 18;

    private MemberCodec() {
    }

    public static void encode(ClientMessage clientMessage, Member member) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[18]);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 0, member.getUuid());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, member.isLiteMember());
        clientMessage.add(initialFrame);
        AddressCodec.encode(clientMessage, member.getAddress());
        MapCodec.encode(clientMessage, member.getAttributes(), StringCodec::encode, StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MemberImpl decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 0);
        boolean liteMember = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        Address address = AddressCodec.decode(iterator);
        Map<String, String> attributes = MapCodec.decode(iterator, StringCodec::decode, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new MemberImpl(address, uuid, attributes, liteMember);
    }
}

