/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.version.MemberVersion;

public final class MemberVersionCodec {
    private static final int MAJOR_FIELD_OFFSET = 0;
    private static final int MINOR_FIELD_OFFSET = 4;
    private static final int PATCH_FIELD_OFFSET = 8;
    private static final int INITIAL_FRAME_SIZE = 12;

    private MemberVersionCodec() {
    }

    public static void encode(ClientMessage clientMessage, MemberVersion memberVersion) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[12]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, memberVersion.getMajor());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 4, memberVersion.getMinor());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, memberVersion.getPatch());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MemberVersion decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int major = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        int minor = FixedSizeTypesCodec.decodeInt(initialFrame.content, 4);
        int patch = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new MemberVersion(major, minor, patch);
    }
}

