/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.holder;

import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;

public class CacheConfigHolder {
    private String name;
    private String managerPrefix;
    private String uriString;
    private int backupCount;
    private int asyncBackupCount;
    private String inMemoryFormat;
    private EvictionConfigHolder evictionConfigHolder;
    private WanReplicationRef wanReplicationRef;
    private String keyClassName;
    private String valueClassName;
    private Data cacheLoaderFactory;
    private Data cacheWriterFactory;
    private Data expiryPolicyFactory;
    private boolean isReadThrough;
    private boolean isWriteThrough;
    private boolean isStoreByValue;
    private boolean isManagementEnabled;
    private boolean isStatisticsEnabled;
    private HotRestartConfig hotRestartConfig;
    private EventJournalConfig eventJournalConfig;
    private String splitBrainProtectionName;
    private List<Data> listenerConfigurations;
    private MergePolicyConfig mergePolicyConfig;
    private boolean disablePerEntryInvalidationEvents;
    private List<ListenerConfigHolder> cachePartitionLostListenerConfigs;

    public CacheConfigHolder(String name, String managerPrefix, String uriString, int backupCount, int asyncBackupCount, String inMemoryFormat, EvictionConfigHolder evictionConfigHolder, WanReplicationRef wanReplicationRef, String keyClassName, String valueClassName, Data cacheLoaderFactory, Data cacheWriterFactory, Data expiryPolicyFactory, boolean isReadThrough, boolean isWriteThrough, boolean isStoreByValue, boolean isManagementEnabled, boolean isStatisticsEnabled, HotRestartConfig hotRestartConfig, EventJournalConfig eventJournalConfig, String splitBrainProtectionName, List<Data> listenerConfigurations, MergePolicyConfig mergePolicyConfig, boolean disablePerEntryInvalidationEvents, List<ListenerConfigHolder> cachePartitionLostListenerConfigs) {
        this.name = name;
        this.managerPrefix = managerPrefix;
        this.uriString = uriString;
        this.backupCount = backupCount;
        this.asyncBackupCount = asyncBackupCount;
        this.inMemoryFormat = inMemoryFormat;
        this.evictionConfigHolder = evictionConfigHolder;
        this.wanReplicationRef = wanReplicationRef;
        this.keyClassName = keyClassName;
        this.valueClassName = valueClassName;
        this.cacheLoaderFactory = cacheLoaderFactory;
        this.cacheWriterFactory = cacheWriterFactory;
        this.expiryPolicyFactory = expiryPolicyFactory;
        this.isReadThrough = isReadThrough;
        this.isWriteThrough = isWriteThrough;
        this.isStoreByValue = isStoreByValue;
        this.isManagementEnabled = isManagementEnabled;
        this.isStatisticsEnabled = isStatisticsEnabled;
        this.hotRestartConfig = hotRestartConfig;
        this.eventJournalConfig = eventJournalConfig;
        this.splitBrainProtectionName = splitBrainProtectionName;
        this.listenerConfigurations = listenerConfigurations;
        this.mergePolicyConfig = mergePolicyConfig;
        this.disablePerEntryInvalidationEvents = disablePerEntryInvalidationEvents;
        this.cachePartitionLostListenerConfigs = cachePartitionLostListenerConfigs;
    }

    public String getName() {
        return this.name;
    }

    public String getManagerPrefix() {
        return this.managerPrefix;
    }

    public String getUriString() {
        return this.uriString;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public String getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public EvictionConfigHolder getEvictionConfigHolder() {
        return this.evictionConfigHolder;
    }

    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRef;
    }

    public String getKeyClassName() {
        return this.keyClassName;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public Data getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public Data getCacheWriterFactory() {
        return this.cacheWriterFactory;
    }

    public Data getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    public boolean isStoreByValue() {
        return this.isStoreByValue;
    }

    public boolean isManagementEnabled() {
        return this.isManagementEnabled;
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public HotRestartConfig getHotRestartConfig() {
        return this.hotRestartConfig;
    }

    public EventJournalConfig getEventJournalConfig() {
        return this.eventJournalConfig;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public List<Data> getListenerConfigurations() {
        return this.listenerConfigurations;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public boolean isDisablePerEntryInvalidationEvents() {
        return this.disablePerEntryInvalidationEvents;
    }

    public List<ListenerConfigHolder> getCachePartitionLostListenerConfigs() {
        return this.cachePartitionLostListenerConfigs;
    }

    public <K, V> CacheConfig<K, V> asCacheConfig(SerializationService serializationService) {
        CacheConfig config = new CacheConfig();
        config.setName(this.name);
        config.setManagerPrefix(this.managerPrefix);
        config.setUriString(this.uriString);
        config.setBackupCount(this.backupCount);
        config.setAsyncBackupCount(this.asyncBackupCount);
        config.setInMemoryFormat(InMemoryFormat.valueOf(this.inMemoryFormat));
        config.setEvictionConfig(this.evictionConfigHolder.asEvictionConfg(serializationService));
        config.setWanReplicationRef(this.wanReplicationRef);
        config.setKeyClassName(this.keyClassName);
        config.setValueClassName(this.valueClassName);
        config.setCacheLoaderFactory((Factory)serializationService.toObject(this.cacheLoaderFactory));
        config.setCacheWriterFactory((Factory)serializationService.toObject(this.cacheWriterFactory));
        config.setExpiryPolicyFactory((Factory<ExpiryPolicy>)((Factory)serializationService.toObject(this.expiryPolicyFactory)));
        config.setReadThrough(this.isReadThrough);
        config.setWriteThrough(this.isWriteThrough);
        config.setStoreByValue(this.isStoreByValue);
        config.setManagementEnabled(this.isManagementEnabled);
        config.setStatisticsEnabled(this.isStatisticsEnabled);
        config.setHotRestartConfig(this.hotRestartConfig);
        config.setEventJournalConfig(this.eventJournalConfig);
        config.setSplitBrainProtectionName(this.splitBrainProtectionName);
        if (this.listenerConfigurations != null && !this.listenerConfigurations.isEmpty()) {
            config.setListenerConfigurations();
            this.listenerConfigurations.forEach(listener -> config.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)serializationService.toObject(listener)));
        }
        config.setMergePolicyConfig(this.mergePolicyConfig);
        config.setDisablePerEntryInvalidationEvents(this.disablePerEntryInvalidationEvents);
        if (this.cachePartitionLostListenerConfigs != null) {
            ArrayList<CachePartitionLostListenerConfig> partitionLostListenerConfigs = new ArrayList<CachePartitionLostListenerConfig>(this.cachePartitionLostListenerConfigs.size());
            this.cachePartitionLostListenerConfigs.forEach(listenerConfigHolder -> partitionLostListenerConfigs.add((CachePartitionLostListenerConfig)listenerConfigHolder.asListenerConfig(serializationService)));
            config.setPartitionLostListenerConfigs(partitionLostListenerConfigs);
        }
        return config;
    }

    public static <K, V> CacheConfigHolder of(CacheConfig<K, V> config, SerializationService serializationService) {
        if (config == null) {
            return null;
        }
        ArrayList<Data> listenerConfigurations = null;
        Set entryListenerConfigurations = config.getListenerConfigurations();
        if (entryListenerConfigurations != null && !entryListenerConfigurations.isEmpty()) {
            ArrayList<Data> configDatas = listenerConfigurations = new ArrayList<Data>(entryListenerConfigurations.size());
            entryListenerConfigurations.forEach(listenerConfig -> configDatas.add((Data)serializationService.toData(listenerConfig)));
        }
        ArrayList<ListenerConfigHolder> cachePartitionLostListenerConfigs = null;
        List<CachePartitionLostListenerConfig> partitionLostListenerConfigs = config.getPartitionLostListenerConfigs();
        if (partitionLostListenerConfigs != null) {
            ArrayList<ListenerConfigHolder> configs = cachePartitionLostListenerConfigs = new ArrayList<ListenerConfigHolder>(partitionLostListenerConfigs.size());
            partitionLostListenerConfigs.forEach(listenerConfig -> configs.add(ListenerConfigHolder.of(listenerConfig, serializationService)));
        }
        return new CacheConfigHolder(config.getName(), config.getManagerPrefix(), config.getUriString(), config.getBackupCount(), config.getAsyncBackupCount(), config.getInMemoryFormat().name(), EvictionConfigHolder.of(config.getEvictionConfig(), serializationService), config.getWanReplicationRef(), config.getKeyClassName(), config.getValueClassName(), (Data)serializationService.toData(config.getCacheLoaderFactory()), (Data)serializationService.toData(config.getCacheWriterFactory()), (Data)serializationService.toData(config.getExpiryPolicyFactory()), config.isReadThrough(), config.isWriteThrough(), config.isStoreByValue(), config.isManagementEnabled(), config.isStatisticsEnabled(), config.getHotRestartConfig(), config.getEventJournalConfig(), config.getSplitBrainProtectionName(), (List<Data>)listenerConfigurations, config.getMergePolicyConfig(), config.isDisablePerEntryInvalidationEvents(), (List<ListenerConfigHolder>)cachePartitionLostListenerConfigs);
    }
}

