/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetAllScheduledFuturesCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorSubmitToAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorSubmitToPartitionCodec;
import com.hazelcast.client.impl.proxy.ClientScheduledFutureProxy;
import com.hazelcast.client.impl.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.partition.PartitionAware;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.NamedTask;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.ScheduledRunnableAdapter;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import com.hazelcast.scheduledexecutor.impl.TaskDefinition;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class ClientScheduledExecutorProxy
extends PartitionSpecificClientProxy
implements IScheduledExecutorService {
    private static final int SHUTDOWN_TIMEOUT = 10;
    private static final ILogger LOGGER = Logger.getLogger(ClientScheduledExecutorProxy.class);
    private static final ClientMessageDecoder SUBMIT_DECODER = clientMessage -> null;
    private final FutureUtil.ExceptionHandler shutdownExceptionHandler = throwable -> {
        if (throwable != null) {
            if (throwable instanceof SplitBrainProtectionException) {
                ExceptionUtil.sneakyThrow(throwable);
            }
            if (throwable.getCause() instanceof SplitBrainProtectionException) {
                ExceptionUtil.sneakyThrow(throwable.getCause());
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Exception while ExecutorService shutdown", throwable);
        }
    };

    public ClientScheduledExecutorProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    public String toString() {
        return "ClientScheduledExecutorProxy{name='" + this.name + '\'' + '}';
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> schedule(@Nonnull Runnable command, long delay, @Nonnull TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.schedule(adapter, delay, unit);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> schedule(@Nonnull Callable<V> command, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleAtFixedRate(@Nonnull Runnable command, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnMember(@Nonnull Runnable command, @Nonnull Member member, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        Map<Member, IScheduledFuture<V>> futureMap = this.scheduleOnMembers(command, Collections.singleton(member), delay, unit);
        return futureMap.get(member);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnMember(@Nonnull Callable<V> command, @Nonnull Member member, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        return this.scheduleOnMembers(command, Collections.singleton(member), delay, unit).get(member);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnMemberAtFixedRate(@Nonnull Runnable command, @Nonnull Member member, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        Map<Member, IScheduledFuture<V>> futureMap = this.scheduleOnMembersAtFixedRate(command, Collections.singleton(member), initialDelay, period, unit);
        return futureMap.get(member);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnKeyOwner(@Nonnull Runnable command, @Nonnull Object key, long delay, @Nonnull TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnKeyOwner(adapter, key, delay, unit);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnKeyOwner(@Nonnull Callable<V> command, @Nonnull Object key, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(key, "Key is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnKeyOwnerAtFixedRate(@Nonnull Runnable command, @Nonnull Object key, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(key, "Key is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembers(@Nonnull Runnable command, long delay, @Nonnull TimeUnit unit) {
        return this.scheduleOnMembers(command, this.getContext().getClusterService().getMemberList(), delay, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembers(@Nonnull Callable<V> command, long delay, @Nonnull TimeUnit unit) {
        return this.scheduleOnMembers(command, this.getContext().getClusterService().getMemberList(), delay, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembersAtFixedRate(@Nonnull Runnable command, long initialDelay, long period, @Nonnull TimeUnit unit) {
        return this.scheduleOnMembersAtFixedRate(command, this.getContext().getClusterService().getMemberList(), initialDelay, period, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembers(@Nonnull Runnable command, @Nonnull Collection<Member> members, long delay, @Nonnull TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnMembers(adapter, members, delay, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembers(@Nonnull Callable<V> command, @Nonnull Collection<Member> members, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(members, "Members is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        HashMap<Member, IScheduledFuture<IScheduledFuture<V>>> futures = new HashMap<Member, IScheduledFuture<IScheduledFuture<V>>>();
        for (Member member : members) {
            TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
            futures.put(member, this.scheduleOnMember(name, member, definition));
        }
        return futures;
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembersAtFixedRate(@Nonnull Runnable command, @Nonnull Collection<Member> members, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(members, "Members is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        HashMap<Member, IScheduledFuture<IScheduledFuture<V>>> futures = new HashMap<Member, IScheduledFuture<IScheduledFuture<V>>>();
        for (Member member : members) {
            TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
            futures.put(member, this.scheduleOnMember(name, member, definition));
        }
        return futures;
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> getScheduledFuture(@Nonnull ScheduledTaskHandler handler) {
        Preconditions.checkNotNull(handler, "Handler is null");
        return new ClientScheduledFutureProxy(handler, this.getContext());
    }

    @Override
    @Nonnull
    public <V> Map<Member, List<IScheduledFuture<V>>> getAllScheduledFutures() {
        ClientMessage response;
        ClientMessage request = ScheduledExecutorGetAllScheduledFuturesCodec.encodeRequest(this.getName());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.getName()).invoke();
        try {
            response = (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        List<Map.Entry<Member, List<ScheduledTaskHandler>>> urnsPerMember = ScheduledExecutorGetAllScheduledFuturesCodec.decodeResponse((ClientMessage)response).handlers;
        HashMap tasksMap = new HashMap();
        for (Map.Entry entry : urnsPerMember) {
            ArrayList memberTasks = new ArrayList();
            for (ScheduledTaskHandler scheduledTaskHandler : (List)entry.getValue()) {
                memberTasks.add(new ClientScheduledFutureProxy(scheduledTaskHandler, this.getContext()));
            }
            tasksMap.put((Member)entry.getKey(), memberTasks);
        }
        return tasksMap;
    }

    @Override
    public void shutdown() {
        Collection<Member> members = this.getContext().getClusterService().getMemberList();
        LinkedList calls = new LinkedList();
        for (Member member : members) {
            ClientMessage request = ScheduledExecutorShutdownCodec.encodeRequest(this.getName(), member.getAddress());
            calls.add(this.doSubmitOnAddress(request, SUBMIT_DECODER, member.getAddress()));
        }
        FutureUtil.waitWithDeadline(calls, 10L, TimeUnit.SECONDS, this.shutdownExceptionHandler);
    }

    private <T> ScheduledRunnableAdapter<T> createScheduledRunnableAdapter(Runnable command) {
        Preconditions.checkNotNull(command, "Command is null");
        return new ScheduledRunnableAdapter(command);
    }

    @Nonnull
    private <V> IScheduledFuture<V> createFutureProxy(ScheduledTaskHandler handler) {
        return new ClientScheduledFutureProxy(handler, this.getContext());
    }

    @Nonnull
    private <V> IScheduledFuture<V> createFutureProxy(int partitionId, String taskName) {
        return this.createFutureProxy(ScheduledTaskHandlerImpl.of(partitionId, this.getName(), taskName));
    }

    @Nonnull
    private <V> IScheduledFuture<V> createFutureProxy(Address address, String taskName) {
        return this.createFutureProxy(ScheduledTaskHandlerImpl.of(address, this.getName(), taskName));
    }

    private int getKeyPartitionId(Object key) {
        return this.getClient().getPartitionService().getPartition(key).getPartitionId();
    }

    private int getTaskOrKeyPartitionId(Callable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)((Object)task)).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private int getTaskOrKeyPartitionId(Runnable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)((Object)task)).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private String extractNameOrGenerateOne(Object command) {
        String name = null;
        if (command instanceof NamedTask) {
            name = ((NamedTask)command).getName();
        }
        return name != null ? name : UuidUtil.newUnsecureUuidString();
    }

    @Nonnull
    private <V> IScheduledFuture<V> scheduleOnPartition(String name, TaskDefinition definition, int partitionId) {
        TimeUnit unit = definition.getUnit();
        Object commandData = this.getSerializationService().toData(definition.getCommand());
        ClientMessage request = ScheduledExecutorSubmitToPartitionCodec.encodeRequest(this.getName(), definition.getType().getId(), definition.getName(), commandData, unit.toMillis(definition.getInitialDelay()), unit.toMillis(definition.getPeriod()));
        try {
            new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return this.createFutureProxy(partitionId, name);
    }

    @Nonnull
    private <V> IScheduledFuture<V> scheduleOnMember(String name, Member member, TaskDefinition definition) {
        TimeUnit unit = definition.getUnit();
        Object commandData = this.getSerializationService().toData(definition.getCommand());
        ClientMessage request = ScheduledExecutorSubmitToAddressCodec.encodeRequest(this.getName(), member.getAddress(), definition.getType().getId(), definition.getName(), commandData, unit.toMillis(definition.getInitialDelay()), unit.toMillis(definition.getPeriod()));
        try {
            new ClientInvocation(this.getClient(), request, (Object)this.getName(), member.getAddress()).invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return this.createFutureProxy(member.getAddress(), name);
    }

    private <T> ClientDelegatingFuture<T> doSubmitOnAddress(ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder, Address address) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, (Object)this.getName(), address).invoke();
            return new ClientDelegatingFuture(future, this.getSerializationService(), clientMessageDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

