/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.Client;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.impl.ClientImpl;
import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddClusterViewListenerCodec;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberAttributeEvent;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.cluster.impl.AbstractMember;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientClusterViewService
implements ClientClusterService,
ClientPartitionService {
    private static final int INITIAL_MEMBERS_TIMEOUT_SECONDS = 120;
    private static final ListenerMessageCodec CLUSTER_VIEW_LISTENER_CODEC = new ListenerMessageCodec(){

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return ClientAddClusterViewListenerCodec.encodeRequest(localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return UuidUtil.NIL_UUID;
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return null;
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return true;
        }
    };
    private static final ClusterViewSnapshot EMPTY_SNAPSHOT = new ClusterViewSnapshot(-1, new LinkedHashMap(), Collections.emptySet(), -1, new Int2ObjectHashMap());
    private static final long BLOCKING_GET_ONCE_SLEEP_MILLIS = 100L;
    private final HazelcastClientInstanceImpl client;
    private final AtomicReference<ClusterViewSnapshot> clusterSnapshot = new AtomicReference<ClusterViewSnapshot>(EMPTY_SNAPSHOT);
    private final ConcurrentMap<UUID, MembershipListener> listeners = new ConcurrentHashMap<UUID, MembershipListener>();
    private final Object clusterViewLock = new Object();
    private final Set<String> labels;
    private final ILogger logger;
    private final ClientConnectionManager connectionManager;
    private final ClientListenerService listenerService;
    private final CountDownLatch initialListFetchedLatch = new CountDownLatch(1);
    private volatile int partitionCount;
    private volatile UUID clusterViewListenerUUID;

    public ClientClusterViewService(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.labels = Collections.unmodifiableSet(client.getClientConfig().getLabels());
        this.logger = client.getLoggingService().getLogger(ClientClusterService.class);
        this.connectionManager = client.getConnectionManager();
        this.listenerService = client.getListenerService();
    }

    private void handleListenerConfigs() {
        ClientConfig clientConfig = this.client.getClientConfig();
        List<ListenerConfig> listenerConfigs = clientConfig.getListenerConfigs();
        for (ListenerConfig listenerConfig : listenerConfigs) {
            EventListener listener = listenerConfig.getImplementation();
            if (listener == null) {
                try {
                    listener = (EventListener)ClassLoaderUtil.newInstance(clientConfig.getClassLoader(), listenerConfig.getClassName());
                }
                catch (Exception e) {
                    this.logger.severe(e);
                }
            }
            if (listener instanceof MembershipListener) {
                this.addMembershipListenerWithoutInit((MembershipListener)listener);
            }
            if (!(listener instanceof PartitionLostListener)) continue;
            this.client.getPartitionService().addPartitionLostListener((PartitionLostListener)listener);
        }
    }

    @Override
    public Member getMember(Address address) {
        return (Member)this.clusterSnapshot.get().members.get(address);
    }

    @Override
    public Member getMember(@Nonnull UUID uuid) {
        Preconditions.checkNotNull(uuid, "UUID must not be null");
        Collection<Member> memberList = this.getMemberList();
        for (Member member : memberList) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Collection<Member> getMemberList() {
        return this.clusterSnapshot.get().members.values();
    }

    @Override
    public Collection<Member> getMembers(@Nonnull MemberSelector selector) {
        Preconditions.checkNotNull(selector, "selector must not be null");
        return new MemberSelectingCollection<Member>(this.getMemberList(), selector);
    }

    @Override
    public Address getMasterAddress() {
        Collection<Member> memberList = this.getMemberList();
        return !memberList.isEmpty() ? new Address(memberList.iterator().next().getSocketAddress()) : null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public int getSize(@Nonnull MemberSelector selector) {
        Preconditions.checkNotNull(selector, "selector must not be null");
        int size = 0;
        for (Member member : this.getMemberList()) {
            if (!selector.select(member)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    @Override
    public Client getLocalClient() {
        ClientConnectionManager cm = this.client.getConnectionManager();
        ClientConnection connection = (ClientConnection)cm.getRandomConnection();
        InetSocketAddress inetSocketAddress = connection != null ? connection.getLocalSocketAddress() : null;
        UUID clientUuid = cm.getClientUuid();
        return new ClientImpl(clientUuid, inetSocketAddress, this.client.getName(), this.labels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public UUID addMembershipListener(@Nonnull MembershipListener listener) {
        Preconditions.checkNotNull(listener, "Listener can't be null");
        Object object = this.clusterViewLock;
        synchronized (object) {
            UUID id = this.addMembershipListenerWithoutInit(listener);
            if (listener instanceof InitialMembershipListener) {
                Cluster cluster = this.client.getCluster();
                Set members = this.clusterSnapshot.get().memberSet;
                if (!members.isEmpty()) {
                    InitialMembershipEvent event = new InitialMembershipEvent(cluster, members);
                    ((InitialMembershipListener)listener).init(event);
                }
            }
            return id;
        }
    }

    private UUID addMembershipListenerWithoutInit(@Nonnull MembershipListener listener) {
        UUID id = UuidUtil.newUnsecureUUID();
        this.listeners.put(id, listener);
        return id;
    }

    @Override
    public boolean removeMembershipListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        return this.listeners.remove(registrationId) != null;
    }

    public void start() {
        this.handleListenerConfigs();
        this.clusterViewListenerUUID = this.listenerService.registerListener(CLUSTER_VIEW_LISTENER_CODEC, new ClusterViewListenerHandler());
        ClientConnectionStrategyConfig connectionStrategyConfig = this.client.getClientConfig().getConnectionStrategyConfig();
        boolean asyncStart = connectionStrategyConfig.isAsyncStart();
        if (!asyncStart) {
            this.waitInitialMemberListFetched();
        }
    }

    public void shutdown() {
        UUID lastListenerUUID = this.clusterViewListenerUUID;
        if (lastListenerUUID != null) {
            this.listenerService.deregisterListener(lastListenerUUID);
        }
    }

    private void waitInitialMemberListFetched() {
        try {
            boolean success = this.initialListFetchedLatch.await(120L, TimeUnit.SECONDS);
            if (!success) {
                throw new IllegalStateException("Could not get initial member list from cluster!");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<MembershipEvent> events;
        Object object = this.clusterViewLock;
        synchronized (object) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Resetting the cluster snapshot");
            }
            ClusterViewSnapshot cleanSnapshot = new ClusterViewSnapshot(-1, new LinkedHashMap(), Collections.emptySet(), -1, new Int2ObjectHashMap());
            events = this.detectMembershipEvents(this.clusterSnapshot.get().memberSet, Collections.emptySet());
            this.clusterSnapshot.set(cleanSnapshot);
        }
        this.fireEvents(events);
    }

    private void applyInitialState(int version, Collection<MemberInfo> memberInfos, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion) {
        Int2ObjectHashMap<Address> map = this.convertToPartitionToAddressMap(partitions);
        ClusterViewSnapshot snapshot = this.createSnapshot(version, memberInfos, map, partitionStateVersion);
        this.clusterSnapshot.set(snapshot);
        this.logger.info(this.membersString(snapshot));
        Set members = snapshot.memberSet;
        InitialMembershipEvent event = new InitialMembershipEvent(this.client.getCluster(), members);
        for (MembershipListener listener : this.listeners.values()) {
            if (!(listener instanceof InitialMembershipListener)) continue;
            ((InitialMembershipListener)listener).init(event);
        }
        this.onPartitionTableUpdate();
    }

    private void onPartitionTableUpdate() {
        ClusterViewSnapshot clusterViewSnapshot = this.clusterSnapshot.get();
        Int2ObjectHashMap newPartitions = clusterViewSnapshot.partitions;
        if (this.partitionCount == 0) {
            this.partitionCount = newPartitions.size();
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Processed partition response. partitionStateVersion : " + clusterViewSnapshot.partitionSateVersion + ", partitionCount :" + newPartitions.size());
        }
    }

    private void applyNewState(int memberListVersion, Collection<MemberInfo> memberInfos, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion, ClusterViewSnapshot oldState) {
        ClusterViewSnapshot newState;
        if (this.fromSameMaster(oldState.members, memberInfos)) {
            if (partitionStateVersion > oldState.partitionSateVersion) {
                Int2ObjectHashMap<Address> map = this.convertToPartitionToAddressMap(partitions);
                newState = this.createSnapshot(memberListVersion, memberInfos, map, partitionStateVersion);
            } else {
                newState = this.createSnapshot(memberListVersion, memberInfos, oldState.partitions, oldState.partitionSateVersion);
            }
        } else {
            Int2ObjectHashMap<Address> map = this.convertToPartitionToAddressMap(partitions);
            newState = this.createSnapshot(memberListVersion, memberInfos, map, partitionStateVersion);
        }
        this.clusterSnapshot.set(newState);
        this.onPartitionTableUpdate();
    }

    private boolean fromSameMaster(Map<Address, Member> currentMembers, Collection<MemberInfo> newMemberInfos) {
        Iterator<Member> iterator = currentMembers.values().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Member masterMember = iterator.next();
        MemberInfo newMaster = newMemberInfos.iterator().next();
        return masterMember.getUuid().equals(newMaster.getUuid());
    }

    private ClusterViewSnapshot createSnapshot(int version, Collection<MemberInfo> memberInfos, Int2ObjectHashMap<Address> partitions, int partitionStateVersion) {
        LinkedHashMap<Address, MemberImpl> newMembers = new LinkedHashMap<Address, MemberImpl>();
        for (MemberInfo memberInfo : memberInfos) {
            Address address = memberInfo.getAddress();
            newMembers.put(address, new MemberImpl(address, memberInfo.getVersion(), memberInfo.getUuid(), memberInfo.getAttributes(), memberInfo.isLiteMember()));
        }
        Set memberSet = Collections.unmodifiableSet(new HashSet(newMembers.values()));
        return new ClusterViewSnapshot(version, newMembers, memberSet, partitionStateVersion, partitions);
    }

    private List<MembershipEvent> detectMembershipEvents(Set<Member> prevMembers, Set<Member> currentMembers) {
        LinkedList<Member> newMembers = new LinkedList<Member>();
        HashSet<Member> deadMembers = new HashSet<Member>(prevMembers);
        for (Member member : currentMembers) {
            if (deadMembers.remove(member)) continue;
            newMembers.add(member);
        }
        LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
        for (Member member : deadMembers) {
            Connection connection;
            events.add(new MembershipEvent(this.client.getCluster(), member, 2, currentMembers));
            Address address = member.getAddress();
            if (this.getMember(address) != null || (connection = this.connectionManager.getConnection(address)) == null) continue;
            connection.close(null, new TargetDisconnectedException("The client has closed the connection to this member, after receiving a member left event from the cluster. " + connection));
        }
        for (Member member : newMembers) {
            events.add(new MembershipEvent(this.client.getCluster(), member, 1, currentMembers));
        }
        if (events.size() != 0) {
            this.logger.info(this.membersString(this.clusterSnapshot.get()));
        }
        return events;
    }

    private String membersString(ClusterViewSnapshot snapshot) {
        Collection members = snapshot.members.values();
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        sb.append(members.size());
        sb.append("] {");
        for (Member member : members) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    private void fireEvents(List<MembershipEvent> events) {
        for (MembershipEvent event : events) {
            for (MembershipListener listener : this.listeners.values()) {
                if (event.getEventType() == 1) {
                    listener.memberAdded(event);
                    continue;
                }
                listener.memberRemoved(event);
            }
        }
    }

    private Int2ObjectHashMap<Address> convertToPartitionToAddressMap(Collection<Map.Entry<Address, List<Integer>>> partitions) {
        Int2ObjectHashMap<Address> newPartitions = new Int2ObjectHashMap<Address>();
        for (Map.Entry<Address, List<Integer>> entry : partitions) {
            Address address = entry.getKey();
            for (Integer partition : entry.getValue()) {
                newPartitions.put(partition, address);
            }
        }
        return newPartitions;
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        return (Address)this.clusterSnapshot.get().partitions.get(partitionId);
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.getPartitionCount();
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return HashUtil.hashToIndex(hash, pc);
    }

    @Override
    public int getPartitionId(Object key) {
        Object data = this.client.getSerializationService().toData(key);
        return this.getPartitionId((Data)data);
    }

    @Override
    public int getPartitionCount() {
        while (this.partitionCount == 0 && this.connectionManager.isAlive()) {
            Set memberList = this.clusterSnapshot.get().memberSet;
            if (MemberSelectingCollection.count(memberList, MemberSelectors.DATA_MEMBER_SELECTOR) == 0) {
                throw new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ExceptionUtil.rethrow(e);
            }
        }
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address owner = ClientClusterViewService.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientClusterViewService.this.getMember(owner);
            }
            return null;
        }

        public String toString() {
            return "PartitionImpl{partitionId=" + this.partitionId + '}';
        }
    }

    private class ClusterViewListenerHandler
    extends ClientAddClusterViewListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ClusterViewListenerHandler() {
        }

        @Override
        public void beforeListenerRegister(Connection connection) {
            if (ClientClusterViewService.this.logger.isFinestEnabled()) {
                ClientClusterViewService.this.logger.finest("Register attempt of ClusterViewListenerHandler to " + connection);
            }
        }

        @Override
        public void onListenerRegister(Connection connection) {
            if (ClientClusterViewService.this.logger.isFinestEnabled()) {
                ClientClusterViewService.this.logger.finest("Registered ClusterViewListenerHandler to " + connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMembersViewEvent(int memberListVersion, Collection<MemberInfo> memberInfos, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion) {
            ClusterViewSnapshot clusterViewSnapshot;
            Object snapshot;
            if (ClientClusterViewService.this.logger.isFinestEnabled()) {
                Int2ObjectHashMap map = ClientClusterViewService.this.convertToPartitionToAddressMap(partitions);
                snapshot = ClientClusterViewService.this.createSnapshot(memberListVersion, memberInfos, map, partitionStateVersion);
                ClientClusterViewService.this.logger.finest("Handling new snapshot with membership version: " + memberListVersion + ", partitionStateVersion: " + partitionStateVersion + ", membersString " + ClientClusterViewService.this.membersString((ClusterViewSnapshot)snapshot));
            }
            if ((clusterViewSnapshot = (ClusterViewSnapshot)ClientClusterViewService.this.clusterSnapshot.get()) == EMPTY_SNAPSHOT) {
                snapshot = ClientClusterViewService.this.clusterViewLock;
                synchronized (snapshot) {
                    clusterViewSnapshot = (ClusterViewSnapshot)ClientClusterViewService.this.clusterSnapshot.get();
                    if (clusterViewSnapshot == EMPTY_SNAPSHOT) {
                        ClientClusterViewService.this.applyInitialState(memberListVersion, memberInfos, partitions, partitionStateVersion);
                        ClientClusterViewService.this.initialListFetchedLatch.countDown();
                        return;
                    }
                }
            }
            List events = Collections.emptyList();
            if (memberListVersion >= clusterViewSnapshot.version) {
                Object object = ClientClusterViewService.this.clusterViewLock;
                synchronized (object) {
                    clusterViewSnapshot = (ClusterViewSnapshot)ClientClusterViewService.this.clusterSnapshot.get();
                    if (memberListVersion >= clusterViewSnapshot.version) {
                        Set prevMembers = ((ClusterViewSnapshot)ClientClusterViewService.this.clusterSnapshot.get()).memberSet;
                        ClientClusterViewService.this.applyNewState(memberListVersion, memberInfos, partitions, partitionStateVersion, clusterViewSnapshot);
                        Set currentMembers = ((ClusterViewSnapshot)ClientClusterViewService.this.clusterSnapshot.get()).memberSet;
                        events = ClientClusterViewService.this.detectMembershipEvents(prevMembers, currentMembers);
                    }
                }
            }
            ClientClusterViewService.this.fireEvents(events);
        }

        @Override
        public void handleMemberAttributeChangeEvent(Member member, String key, int operationType, @Nullable String value) {
            Set currentMembers = ((ClusterViewSnapshot)ClientClusterViewService.this.clusterSnapshot.get()).memberSet;
            Cluster cluster = ClientClusterViewService.this.client.getCluster();
            UUID uuid = member.getUuid();
            for (Member target : currentMembers) {
                if (!target.getUuid().equals(uuid)) continue;
                MemberAttributeOperationType type = MemberAttributeOperationType.getValue(operationType);
                ((AbstractMember)target).updateAttribute(type, key, value);
                MemberAttributeEvent event = new MemberAttributeEvent(cluster, target, currentMembers, type, key, value);
                for (MembershipListener listener : ClientClusterViewService.this.listeners.values()) {
                    listener.memberAttributeChanged(event);
                }
            }
        }
    }

    private static final class ClusterViewSnapshot {
        private final int version;
        private final LinkedHashMap<Address, Member> members;
        private final Set<Member> memberSet;
        private final int partitionSateVersion;
        private final Int2ObjectHashMap<Address> partitions;

        private ClusterViewSnapshot(int version, LinkedHashMap<Address, Member> members, Set<Member> memberSet, int partitionSateVersion, Int2ObjectHashMap<Address> partitions) {
            this.version = version;
            this.members = members;
            this.memberSet = memberSet;
            this.partitionSateVersion = partitionSateVersion;
            this.partitions = partitions;
        }
    }
}

