/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientLocalBackupListenerCodec;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.io.IOException;
import java.util.UUID;

public class SmartClientInvocationService
extends AbstractClientInvocationService {
    private static ListenerMessageCodec backupListener = new ListenerMessageCodec(){

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return ClientLocalBackupListenerCodec.encodeRequest();
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return ClientLocalBackupListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return null;
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return false;
        }
    };
    private boolean isBackupAckToClientEnabled;

    public SmartClientInvocationService(HazelcastClientInstanceImpl client) {
        super(client);
    }

    public void addBackupListener() {
        this.isBackupAckToClientEnabled = this.client.getClientConfig().isBackupAckToClientEnabled();
        if (this.isBackupAckToClientEnabled) {
            ClientListenerService listenerService = this.client.getListenerService();
            listenerService.registerListener(backupListener, new BackupEventHandler());
        }
    }

    @Override
    public void invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) throws IOException {
        Address owner = this.partitionService.getPartitionOwner(partitionId);
        if (owner == null) {
            throw new IOException("Partition does not have an owner. partitionId: " + partitionId);
        }
        if (!this.isMember(owner)) {
            throw new TargetNotMemberException("Partition owner '" + owner + "' is not a member.");
        }
        invocation.getClientMessage().setPartitionId(partitionId);
        Connection connection = this.getConnection(owner);
        this.send0(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnRandomTarget(ClientInvocation invocation) throws IOException {
        Connection connection = this.connectionManager.getRandomConnection();
        if (connection == null) {
            throw new IOException("No connection found to invoke");
        }
        this.send0(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnTarget(ClientInvocation invocation, Address target) throws IOException {
        if (!this.isMember(target)) {
            throw new TargetNotMemberException("Target '" + target + "' is not a member.");
        }
        Connection connection = this.getConnection(target);
        this.invokeOnConnection(invocation, (ClientConnection)connection);
    }

    private Connection getConnection(Address target) throws IOException {
        Connection connection = this.connectionManager.getConnection(target);
        if (connection == null) {
            throw new IOException("No available connection to address " + target);
        }
        return connection;
    }

    @Override
    public void invokeOnConnection(ClientInvocation invocation, ClientConnection connection) throws IOException {
        this.send0(invocation, connection);
    }

    private void send0(ClientInvocation invocation, ClientConnection connection) throws IOException {
        if (this.isBackupAckToClientEnabled) {
            invocation.getClientMessage().getStartFrame().flags |= 0x100;
        }
        this.send(invocation, connection);
    }

    boolean isMember(Address target) {
        Member member = this.client.getClientClusterService().getMember(target);
        return member != null;
    }

    public class BackupEventHandler
    extends ClientLocalBackupListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        @Override
        public void handleBackupEvent(long sourceInvocationCorrelationId) {
            ClientInvocation invocation = SmartClientInvocationService.this.getInvocation(sourceInvocationCorrelationId);
            if (invocation == null) {
                if (SmartClientInvocationService.this.invocationLogger.isFinestEnabled()) {
                    SmartClientInvocationService.this.invocationLogger.finest("Invocation not found for backup event, invocation id " + sourceInvocationCorrelationId);
                }
                return;
            }
            invocation.notifyBackupComplete();
        }
    }
}

