/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.statistics;

import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.internal.nearcache.NearCacheManager;
import java.util.Collection;

class NearCacheMetricsProvider
implements DynamicMetricsProvider {
    private final Collection<NearCacheManager> nearCacheManagers;

    NearCacheMetricsProvider(Collection<NearCacheManager> nearCacheManagers) {
        this.nearCacheManagers = nearCacheManagers;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        descriptor.withPrefix("nearcache");
        this.nearCacheManagers.stream().flatMap(nearCacheManager -> nearCacheManager.listAllNearCaches().stream()).forEach(nearCache -> {
            String nearCacheName = nearCache.getName();
            NearCacheStatsImpl nearCacheStats = (NearCacheStatsImpl)nearCache.getNearCacheStats();
            context.collect(descriptor.copy().withDiscriminator("name", nearCacheName), nearCacheStats);
        });
    }
}

