/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.WanReplicationPublisher;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractWanPublisherConfig
implements IdentifiedDataSerializable {
    protected String publisherId = "";
    protected String className = "";
    protected WanReplicationPublisher implementation;
    protected Map<String, Comparable> properties = new HashMap<String, Comparable>();

    public String getPublisherId() {
        return this.publisherId;
    }

    public AbstractWanPublisherConfig setPublisherId(String publisherId) {
        this.publisherId = publisherId;
        return this;
    }

    @Nonnull
    public Map<String, Comparable> getProperties() {
        return this.properties;
    }

    public AbstractWanPublisherConfig setProperties(@Nonnull Map<String, Comparable> properties) {
        this.properties = Preconditions.checkNotNull(properties, "Properties must not be null");
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public AbstractWanPublisherConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public WanReplicationPublisher getImplementation() {
        return this.implementation;
    }

    public AbstractWanPublisherConfig setImplementation(WanReplicationPublisher implementation) {
        this.implementation = implementation;
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int size = this.properties.size();
        out.writeInt(size);
        for (Map.Entry<String, Comparable> entry : this.properties.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeUTF(this.className);
        out.writeObject(this.implementation);
        out.writeUTF(this.publisherId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.properties.put(in.readUTF(), (Comparable)in.readObject());
        }
        this.className = in.readUTF();
        this.implementation = (WanReplicationPublisher)in.readObject();
        this.publisherId = in.readUTF();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractWanPublisherConfig that = (AbstractWanPublisherConfig)o;
        if (!this.publisherId.equals(that.publisherId)) {
            return false;
        }
        if (!Objects.equals(this.className, that.className)) {
            return false;
        }
        if (!Objects.equals(this.implementation, that.implementation)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.publisherId.hashCode();
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.implementation != null ? this.implementation.hashCode() : 0);
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

