/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.CustomWanPublisherConfig;
import com.hazelcast.config.WanBatchReplicationPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class WanReplicationConfig
implements IdentifiedDataSerializable {
    private String name;
    private WanConsumerConfig wanConsumerConfig;
    private List<CustomWanPublisherConfig> customPublisherConfigs = new ArrayList<CustomWanPublisherConfig>(0);
    private List<WanBatchReplicationPublisherConfig> batchPublisherConfigs = new ArrayList<WanBatchReplicationPublisherConfig>(1);

    public String getName() {
        return this.name;
    }

    public WanReplicationConfig setName(@Nonnull String name) {
        this.name = Preconditions.checkNotNull(name, "Name must not be null");
        return this;
    }

    public WanConsumerConfig getWanConsumerConfig() {
        return this.wanConsumerConfig;
    }

    public WanReplicationConfig setWanConsumerConfig(WanConsumerConfig wanConsumerConfig) {
        this.wanConsumerConfig = wanConsumerConfig;
        return this;
    }

    @Nonnull
    public List<CustomWanPublisherConfig> getCustomPublisherConfigs() {
        return this.customPublisherConfigs;
    }

    public WanReplicationConfig setCustomPublisherConfigs(@Nonnull List<CustomWanPublisherConfig> customPublisherConfigs) {
        this.customPublisherConfigs = Preconditions.checkNotNull(customPublisherConfigs, "Publisher configurations must not be null");
        return this;
    }

    @Nonnull
    public List<WanBatchReplicationPublisherConfig> getBatchPublisherConfigs() {
        return this.batchPublisherConfigs;
    }

    public WanReplicationConfig setBatchPublisherConfigs(@Nonnull List<WanBatchReplicationPublisherConfig> batchPublisherConfigs) {
        this.batchPublisherConfigs = Preconditions.checkNotNull(batchPublisherConfigs, "Publisher configurations must not be null");
        return this;
    }

    public WanReplicationConfig addWanBatchReplicationPublisherConfig(WanBatchReplicationPublisherConfig config) {
        this.batchPublisherConfigs.add(config);
        return this;
    }

    public WanReplicationConfig addCustomPublisherConfig(CustomWanPublisherConfig config) {
        this.customPublisherConfigs.add(config);
        return this;
    }

    public String toString() {
        return "WanReplicationConfig{name='" + this.name + '\'' + ", wanConsumerConfig=" + this.wanConsumerConfig + ", customPublisherConfigs=" + this.customPublisherConfigs + ", batchPublisherConfigs=" + this.batchPublisherConfigs + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.wanConsumerConfig);
        SerializationUtil.writeCollection(this.batchPublisherConfigs, out);
        SerializationUtil.writeCollection(this.customPublisherConfigs, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.wanConsumerConfig = (WanConsumerConfig)in.readObject();
        this.batchPublisherConfigs = SerializationUtil.readList(in);
        this.customPublisherConfigs = SerializationUtil.readList(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WanReplicationConfig that = (WanReplicationConfig)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.wanConsumerConfig != null ? !this.wanConsumerConfig.equals(that.wanConsumerConfig) : that.wanConsumerConfig != null) {
            return false;
        }
        if (!this.customPublisherConfigs.equals(that.customPublisherConfigs)) {
            return false;
        }
        return this.batchPublisherConfigs.equals(that.batchPublisherConfigs);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.wanConsumerConfig != null ? this.wanConsumerConfig.hashCode() : 0);
        result = 31 * result + this.customPublisherConfigs.hashCode();
        result = 31 * result + this.batchPublisherConfigs.hashCode();
        return result;
    }
}

