/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class UnsafeModePartitionState
implements IdentifiedDataSerializable {
    private long commitIndex;
    private final transient Map<Long, Operation> waitingOperations = new HashMap<Long, Operation>();

    long nextCommitIndex() {
        return ++this.commitIndex;
    }

    boolean registerWaitingOp(long commitIndex, Operation op) {
        return this.waitingOperations.putIfAbsent(commitIndex, op) == null;
    }

    Operation removeWaitingOp(long index) {
        return this.waitingOperations.remove(index);
    }

    Collection<Operation> getWaitingOps() {
        return this.waitingOperations.values();
    }

    void apply(UnsafeModePartitionState state) {
        this.commitIndex = state.commitIndex;
        this.waitingOperations.clear();
        this.waitingOperations.putAll(state.waitingOperations);
    }

    void reset() {
        this.commitIndex = 0L;
        this.waitingOperations.clear();
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 51;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.commitIndex);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.commitIndex = in.readLong();
    }
}

