/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation.unsafe;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.operation.unsafe.AbstractUnsafeRaftOp;
import com.hazelcast.cp.internal.operation.unsafe.UnsafeRaftBackupOp;
import com.hazelcast.cp.internal.raft.impl.util.PostponedResponse;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Operation;

public class UnsafeRaftReplicateOp
extends AbstractUnsafeRaftOp
implements BackupAwareOperation {
    public UnsafeRaftReplicateOp() {
    }

    public UnsafeRaftReplicateOp(CPGroupId groupId, RaftOp op) {
        super(groupId, op);
    }

    @Override
    CallStatus handleResponse(long commitIndex, Object response) {
        if (response == PostponedResponse.INSTANCE) {
            RaftService service = (RaftService)this.getService();
            service.registerUnsafeWaitingOperation(this.groupId, commitIndex, this);
            return CallStatus.DONE_VOID_BACKUP;
        }
        return CallStatus.DONE_RESPONSE;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public int getSyncBackupCount() {
        return 1;
    }

    @Override
    public int getAsyncBackupCount() {
        return 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new UnsafeRaftBackupOp(this.groupId, this.op);
    }

    @Override
    public int getClassId() {
        return 42;
    }
}

