/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.longregister;

import com.hazelcast.internal.longregister.LongRegister;
import com.hazelcast.internal.longregister.LongRegisterProxy;
import com.hazelcast.internal.longregister.operations.LongRegisterReplicationOperation;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.MigrationAwareService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LongRegisterService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:atomicLongService";
    private final ConcurrentMap<String, LongRegister> registers = new ConcurrentHashMap<String, LongRegister>();
    private final ConstructorFunction<String, LongRegister> longRegisterConstructorFunction = key -> new LongRegister();
    private final NodeEngine nodeEngine;

    public LongRegisterService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public LongRegister getLongRegister(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.registers, name, this.longRegisterConstructorFunction);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.registers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public LongRegisterProxy createDistributedObject(String name, boolean local) {
        return new LongRegisterProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        this.registers.remove(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (event.getReplicaIndex() > 1) {
            return null;
        }
        HashMap<String, Long> data = new HashMap<String, Long>();
        int partitionId = event.getPartitionId();
        for (Map.Entry containerEntry : this.registers.entrySet()) {
            String name = (String)containerEntry.getKey();
            if (partitionId != this.getPartitionId(name)) continue;
            LongRegister register = (LongRegister)containerEntry.getValue();
            data.put(name, register.get());
        }
        return data.isEmpty() ? null : new LongRegisterReplicationOperation(data);
    }

    private int getPartitionId(String name) {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        String partitionKey = StringPartitioningStrategy.getPartitionKey(name);
        return partitionService.getPartitionId(partitionKey);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        int thresholdReplicaIndex;
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE && ((thresholdReplicaIndex = event.getNewReplicaIndex()) == -1 || thresholdReplicaIndex > 1)) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        int thresholdReplicaIndex;
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION && ((thresholdReplicaIndex = event.getCurrentReplicaIndex()) == -1 || thresholdReplicaIndex > 1)) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    private void clearPartitionReplica(int partitionId) {
        this.registers.keySet().removeIf(name -> this.getPartitionId((String)name) == partitionId);
    }
}

