/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanBatchReplicationPublisherConfig;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.management.dto.AliasedDiscoveryConfigDTO;
import com.hazelcast.internal.management.dto.DiscoveryConfigDTO;
import com.hazelcast.internal.management.dto.WanSyncConfigDTO;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.json.internal.JsonSerializable;
import com.hazelcast.wan.WanPublisherState;
import java.util.Map;
import java.util.function.Consumer;

public class WanBatchReplicationPublisherConfigDTO
implements JsonSerializable {
    private WanBatchReplicationPublisherConfig config;

    public WanBatchReplicationPublisherConfigDTO() {
    }

    public WanBatchReplicationPublisherConfigDTO(WanBatchReplicationPublisherConfig config) {
        this.config = config;
    }

    @Override
    public JsonObject toJson() {
        WanSyncConfig syncConfig;
        JsonObject root = new JsonObject();
        root.add("clusterName", this.config.getClusterName());
        if (this.config.getPublisherId() != null) {
            root.add("publisherId", this.config.getPublisherId());
        }
        root.add("batchSize", this.config.getBatchSize());
        root.add("batchMaxDelayMillis", this.config.getBatchMaxDelayMillis());
        root.add("responseTimeoutMillis", this.config.getResponseTimeoutMillis());
        if (this.config.getAcknowledgeType() != null) {
            root.add("acknowledgeType", this.config.getAcknowledgeType().getId());
        }
        if (this.config.getInitialPublisherState() != null) {
            root.add("initialPublisherState", this.config.getInitialPublisherState().getId());
        }
        root.add("snapshotEnabled", this.config.isSnapshotEnabled());
        root.add("idleMaxParkNs", this.config.getIdleMaxParkNs());
        root.add("idleMinParkNs", this.config.getIdleMinParkNs());
        root.add("maxConcurrentInvocations", this.config.getMaxConcurrentInvocations());
        root.add("discoveryPeriodSeconds", this.config.getDiscoveryPeriodSeconds());
        root.add("useEndpointPrivateAddress", this.config.isUseEndpointPrivateAddress());
        if (this.config.getQueueFullBehavior() != null) {
            root.add("queueFullBehavior", this.config.getQueueFullBehavior().getId());
        }
        root.add("maxTargetEndpoints", this.config.getMaxTargetEndpoints());
        root.add("queueCapacity", this.config.getQueueCapacity());
        if (this.config.getTargetEndpoints() != null) {
            root.add("targetEndpoints", this.config.getTargetEndpoints());
        }
        this.serializeAliasedDiscoveryConfig(root, "aws", this.config.getAwsConfig());
        this.serializeAliasedDiscoveryConfig(root, "gcp", this.config.getGcpConfig());
        this.serializeAliasedDiscoveryConfig(root, "azure", this.config.getAzureConfig());
        this.serializeAliasedDiscoveryConfig(root, "kubernetes", this.config.getKubernetesConfig());
        this.serializeAliasedDiscoveryConfig(root, "eureka", this.config.getEurekaConfig());
        DiscoveryConfig discoveryConfig = this.config.getDiscoveryConfig();
        if (discoveryConfig != null) {
            root.add("discovery", new DiscoveryConfigDTO(discoveryConfig).toJson());
        }
        if ((syncConfig = this.config.getWanSyncConfig()) != null) {
            root.add("sync", new WanSyncConfigDTO(syncConfig).toJson());
        }
        if (this.config.getEndpoint() != null) {
            root.add("endpoint", this.config.getEndpoint());
        }
        if (!MapUtil.isNullOrEmpty(this.config.getProperties())) {
            root.add("properties", JsonUtil.toJsonObject(this.config.getProperties()));
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonValue syncJson;
        JsonValue discoveryJson;
        EurekaConfig eurekaConfig;
        KubernetesConfig kubernetesConfig;
        AzureConfig azureConfig;
        GcpConfig gcpConfig;
        this.config = new WanBatchReplicationPublisherConfig();
        this.consumeIfExists(json, "clusterName", v -> this.config.setClusterName(v.asString()));
        this.consumeIfExists(json, "publisherId", v -> this.config.setPublisherId(v.asString()));
        this.consumeIfExists(json, "batchSize", v -> this.config.setBatchSize(v.asInt()));
        this.consumeIfExists(json, "batchMaxDelayMillis", v -> this.config.setBatchMaxDelayMillis(v.asInt()));
        this.consumeIfExists(json, "responseTimeoutMillis", v -> this.config.setResponseTimeoutMillis(v.asInt()));
        this.consumeIfExists(json, "acknowledgeType", v -> this.config.setAcknowledgeType(WanAcknowledgeType.getById(v.asInt())));
        this.consumeIfExists(json, "initialPublisherState", v -> this.config.setInitialPublisherState(WanPublisherState.getByType((byte)v.asInt())));
        this.consumeIfExists(json, "snapshotEnabled", v -> this.config.setSnapshotEnabled(v.asBoolean()));
        this.consumeIfExists(json, "idleMaxParkNs", v -> this.config.setIdleMaxParkNs(v.asLong()));
        this.consumeIfExists(json, "idleMinParkNs", v -> this.config.setIdleMinParkNs(v.asLong()));
        this.consumeIfExists(json, "maxConcurrentInvocations", v -> this.config.setMaxConcurrentInvocations(v.asInt()));
        this.consumeIfExists(json, "discoveryPeriodSeconds", v -> this.config.setDiscoveryPeriodSeconds(v.asInt()));
        this.consumeIfExists(json, "useEndpointPrivateAddress", v -> this.config.setUseEndpointPrivateAddress(v.asBoolean()));
        this.consumeIfExists(json, "queueFullBehavior", v -> this.config.setQueueFullBehavior(WanQueueFullBehavior.getByType(v.asInt())));
        this.consumeIfExists(json, "maxTargetEndpoints", v -> this.config.setMaxTargetEndpoints(v.asInt()));
        this.consumeIfExists(json, "queueCapacity", v -> this.config.setQueueCapacity(v.asInt()));
        this.consumeIfExists(json, "targetEndpoints", v -> this.config.setTargetEndpoints(v.asString()));
        AwsConfig awsConfig = (AwsConfig)this.deserializeAliasedDiscoveryConfig(json, "aws");
        if (awsConfig != null) {
            this.config.setAwsConfig(awsConfig);
        }
        if ((gcpConfig = (GcpConfig)this.deserializeAliasedDiscoveryConfig(json, "gcp")) != null) {
            this.config.setGcpConfig(gcpConfig);
        }
        if ((azureConfig = (AzureConfig)this.deserializeAliasedDiscoveryConfig(json, "azure")) != null) {
            this.config.setAzureConfig(azureConfig);
        }
        if ((kubernetesConfig = (KubernetesConfig)this.deserializeAliasedDiscoveryConfig(json, "kubernetes")) != null) {
            this.config.setKubernetesConfig(kubernetesConfig);
        }
        if ((eurekaConfig = (EurekaConfig)this.deserializeAliasedDiscoveryConfig(json, "eureka")) != null) {
            this.config.setEurekaConfig(eurekaConfig);
        }
        if ((discoveryJson = json.get("discovery")) != null && !discoveryJson.isNull()) {
            DiscoveryConfigDTO discoveryDTO = new DiscoveryConfigDTO();
            discoveryDTO.fromJson(discoveryJson.asObject());
            this.config.setDiscoveryConfig(discoveryDTO.getConfig());
        }
        if ((syncJson = json.get("sync")) != null && !syncJson.isNull()) {
            WanSyncConfigDTO syncDTO = new WanSyncConfigDTO();
            syncDTO.fromJson(syncJson.asObject());
            this.config.setWanSyncConfig(syncDTO.getConfig());
        }
        this.consumeIfExists(json, "endpoint", v -> this.config.setEndpoint(v.asString()));
        this.config.setProperties((Map)JsonUtil.fromJsonObject((JsonObject)json.get("properties")));
    }

    private void consumeIfExists(JsonObject json, String attribute, Consumer<JsonValue> valueConsumer) {
        JsonValue value = json.get(attribute);
        if (value != null && !value.isNull()) {
            valueConsumer.accept(value);
        }
    }

    private AliasedDiscoveryConfig deserializeAliasedDiscoveryConfig(JsonObject json, String tag) {
        JsonValue configJson = json.get(tag);
        if (configJson != null && !configJson.isNull()) {
            AliasedDiscoveryConfigDTO dto = new AliasedDiscoveryConfigDTO(tag);
            dto.fromJson(configJson.asObject());
            return dto.getConfig();
        }
        return null;
    }

    private void serializeAliasedDiscoveryConfig(JsonObject object, String tag, AliasedDiscoveryConfig config) {
        if (config != null) {
            object.add(tag, new AliasedDiscoveryConfigDTO(config).toJson());
        }
    }

    public WanBatchReplicationPublisherConfig getConfig() {
        return this.config;
    }
}

