/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.CustomWanPublisherConfig;
import com.hazelcast.config.WanBatchReplicationPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.management.dto.CustomWanPublisherConfigDTO;
import com.hazelcast.internal.management.dto.WanBatchReplicationPublisherConfigDTO;
import com.hazelcast.internal.management.dto.WanConsumerConfigDTO;
import com.hazelcast.json.internal.JsonSerializable;

public class WanReplicationConfigDTO
implements JsonSerializable {
    private WanReplicationConfig config;

    public WanReplicationConfigDTO(WanReplicationConfig config) {
        this.config = config;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        if (this.config.getName() != null) {
            root.add("name", this.config.getName());
        }
        JsonArray batchPublishers = new JsonArray();
        JsonArray customPublishers = new JsonArray();
        for (WanBatchReplicationPublisherConfig wanBatchReplicationPublisherConfig : this.config.getBatchPublisherConfigs()) {
            batchPublishers.add(new WanBatchReplicationPublisherConfigDTO(wanBatchReplicationPublisherConfig).toJson());
        }
        for (CustomWanPublisherConfig customWanPublisherConfig : this.config.getCustomPublisherConfigs()) {
            customPublishers.add(new CustomWanPublisherConfigDTO(customWanPublisherConfig).toJson());
        }
        root.add("batchPublishers", batchPublishers);
        root.add("customPublishers", customPublishers);
        WanConsumerConfig consumerConfig = this.config.getWanConsumerConfig();
        if (consumerConfig != null) {
            root.add("consumer", new WanConsumerConfigDTO(consumerConfig).toJson());
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonValue consumer;
        JsonValue customPublishers;
        JsonValue batchPublishers;
        this.config = new WanReplicationConfig();
        JsonValue name = json.get("name");
        if (name != null) {
            this.config.setName(name.asString());
        }
        if ((batchPublishers = json.get("batchPublishers")) != null && !batchPublishers.isNull()) {
            for (Object jsonValue : batchPublishers.asArray()) {
                WanBatchReplicationPublisherConfigDTO dto = new WanBatchReplicationPublisherConfigDTO();
                dto.fromJson(((JsonValue)jsonValue).asObject());
                this.config.addWanBatchReplicationPublisherConfig(dto.getConfig());
            }
        }
        if ((customPublishers = json.get("customPublishers")) != null && !customPublishers.isNull()) {
            for (JsonValue jsonValue : customPublishers.asArray()) {
                CustomWanPublisherConfigDTO dto = new CustomWanPublisherConfigDTO();
                dto.fromJson(jsonValue.asObject());
                this.config.addCustomPublisherConfig(dto.getConfig());
            }
        }
        if ((consumer = json.get("consumer")) != null && !consumer.isNull()) {
            WanConsumerConfigDTO consumerDTO = new WanConsumerConfigDTO();
            consumerDTO.fromJson(consumer.asObject());
            this.config.setWanConsumerConfig(consumerDTO.getConfig());
        }
    }

    public WanReplicationConfig getConfig() {
        return this.config;
    }
}

