/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.config.MapConfigReadOnly;
import com.hazelcast.internal.management.operation.AbstractManagementOperation;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class UpdateMapConfigOperation
extends AbstractManagementOperation {
    private boolean readBackupData;
    private int timeToLiveSeconds;
    private int maxIdleSeconds;
    private int maxSize;
    private int maxSizePolicyId;
    private int evictionPolicyId;
    private String mapName;

    public UpdateMapConfigOperation() {
    }

    public UpdateMapConfigOperation(String mapName, int timeToLiveSeconds, int maxIdleSeconds, int maxSize, int maxSizePolicyId, boolean readBackupData, int evictionPolicyId) {
        this.mapName = mapName;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.maxIdleSeconds = maxIdleSeconds;
        this.maxSize = maxSize;
        this.maxSizePolicyId = maxSizePolicyId;
        this.readBackupData = readBackupData;
        this.evictionPolicyId = evictionPolicyId;
    }

    @Override
    public void run() throws Exception {
        MapService service = (MapService)this.getService();
        MapConfig oldConfig = service.getMapServiceContext().getMapContainer(this.mapName).getMapConfig();
        MapConfig newConfig = new MapConfig(oldConfig);
        newConfig.setTimeToLiveSeconds(this.timeToLiveSeconds);
        newConfig.setMaxIdleSeconds(this.maxIdleSeconds);
        newConfig.setReadBackupData(this.readBackupData);
        EvictionConfig evictionConfig = newConfig.getEvictionConfig();
        evictionConfig.setEvictionPolicy(EvictionPolicy.getById(this.evictionPolicyId));
        evictionConfig.setMaxSizePolicy(MaxSizePolicy.getById(this.maxSizePolicyId));
        evictionConfig.setSize(this.maxSize);
        MapContainer mapContainer = service.getMapServiceContext().getMapContainer(this.mapName);
        mapContainer.setMapConfig(new MapConfigReadOnly(newConfig));
        mapContainer.initEvictor();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxIdleSeconds);
        out.writeInt(this.maxSize);
        out.writeInt(this.maxSizePolicyId);
        out.writeBoolean(this.readBackupData);
        out.writeInt(this.evictionPolicyId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.timeToLiveSeconds = in.readInt();
        this.maxIdleSeconds = in.readInt();
        this.maxSize = in.readInt();
        this.maxSizePolicyId = in.readInt();
        this.readBackupData = in.readBoolean();
        this.evictionPolicyId = in.readInt();
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

